package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 产品类别
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product_category")
public class ProductCategory implements Serializable {

	/**
	 * 产品类别ID
	 */
	@Id
	//@JsonSerialize(using = NumberToStringSerializer.class)
	@GeneratedValue(generator = "system-uuid")
	@GenericGenerator(name = "system-uuid", strategy = "guid")
	@Column(name = "product_category_id", nullable = false)
	private String productCategoryId;

	/**
	 * 产品类别名称
	 */
	@Column(name = "product_category_name", nullable = true, length = 128)
	private String productCategoryName;

	/**
	 * 产品类别状态(product_category_status)
	 */
	@Column(name = "product_category_status", nullable = true, length = 32)
	private String productCategoryStatus;

	/**
	 * 产品编码
	 */
	@Column(name = "product_category_code", nullable = true, length = 32)
	private String productCategoryCode;
	
	public String getProductCategoryId() {
		return this.productCategoryId;
	}
	
	public void setProductCategoryId (String  productCategoryId) {
		this.productCategoryId = productCategoryId;
	}
	
	public String getProductCategoryName() {
		return this.productCategoryName;
	}
	
	public void setProductCategoryName(String productCategoryName) {
		this.productCategoryName = productCategoryName;
	}
	
	public String getProductCategoryStatus() {
		return this.productCategoryStatus;
	}
	
	public void setProductCategoryStatus(String productCategoryStatus) {
		this.productCategoryStatus = productCategoryStatus;
	}
	
	public String getProductCategoryCode() {
		return this.productCategoryCode;
	}
	
	public void setProductCategoryCode(String productCategoryCode) {
		this.productCategoryCode = productCategoryCode;
	}
}
