package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 生产工厂
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "factory")
public class Factory implements Serializable {

	/**
	 * 工厂ID
	 */
	@Id
	//@JsonSerialize(using = NumberToStringSerializer.class)
	@GeneratedValue(generator = "system-uuid")
	@GenericGenerator(name = "system-uuid", strategy = "guid")
	@Column(name = "factory_id", nullable = false)
	private String factoryId;

	/**
	 * 工厂名称
	 */
	@Column(name = "factory_name", nullable = true, length = 255)
	private String factoryName;

	/**
	 * 工厂编码
	 */
	@Column(name = "factory_code", nullable = true, length = 32)
	private String factoryCode;
	
	public String getFactoryId() {
		return this.factoryId;
	}
	
	public void setFactoryId (String  factoryId) {
		this.factoryId = factoryId;
	}
	
	public String getFactoryName() {
		return this.factoryName;
	}
	
	public void setFactoryName(String factoryName) {
		this.factoryName = factoryName;
	}
	
	public String getFactoryCode() {
		return this.factoryCode;
	}
	
	public void setFactoryCode(String factoryCode) {
		this.factoryCode = factoryCode;
	}
}
