package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 品牌
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "brand")
public class Brand implements Serializable {

	/**
	 * 品牌ID
	 */
	@Id
	//@JsonSerialize(using = NumberToStringSerializer.class)
	@GeneratedValue(generator = "system-uuid")
	@GenericGenerator(name = "system-uuid", strategy = "guid")
	@Column(name = "brand_id")
	private String brandId;

	/**
	 * 品牌名称
	 */
	@Column(name = "brand_name", nullable = false, length = 128)
	private String brandName;

	/**
	 * 品牌编码
	 */
	@Column(name = "brand_code", nullable = true, length = 32)
	private String brandCode;

	/**
	 * 品牌备注
	 */
	@Column(name = "brand_remark", nullable = true, length = 1024)
	private String brandRemark;
	
	public String getBrandId() {
		return this.brandId;
	}
	
	public void setBrandId (String  brandId) {
		this.brandId = brandId;
	}
	
	public String getBrandName() {
		return this.brandName;
	}
	
	public void setBrandName(String brandName) {
		this.brandName = brandName;
	}
	
	public String getBrandCode() {
		return this.brandCode;
	}
	
	public void setBrandCode(String brandCode) {
		this.brandCode = brandCode;
	}
	
	public String getBrandRemark() {
		return this.brandRemark;
	}
	
	public void setBrandRemark(String brandRemark) {
		this.brandRemark = brandRemark;
	}
}
