package com.huigou.topsun.product.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.context.Operator;
import com.huigou.topsun.product.application.*;
import com.huigou.topsun.product.domain.*;
import com.huigou.topsun.product.domain.query.ProductQueryRequest;
import com.huigou.topsun.product.domain.vo.ProductAllDataVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ProductController
 *
 * @author qinzhenguan
 * @createDate 2023/11/27 11:19
 **/
@Controller
@ControllerMapping("/product")
public class ProductController extends CommonController {

    @Resource
    private ProductApplication productService;
    @Resource
    private ProductProcessApplication processService;
    @Resource
    private ObjectMapper objectMapper;
    @Resource
    private ProductLossApplication productLossApplication;
    @Resource
    private ProductProcessApplication productProcessApplication;
    @Resource
    private ProductFaceColorApplication productFaceColorApplication;
    @Resource
    private ProductMaterialApplication productMaterialApplication;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/product/";
    }

    /**
     * description
     *
     * @return null
     * @author qinzhenguan
     * @createDate 2023/11/27 11:49
     */
    public String findProduct() {//需要特定类型返回值
        ArrayList<Map<String, Object>> productPage = productService.findProductPage(0, 30);
        HashMap<Object, Object> map = new HashMap<>(3);
        map.put("Rows", productPage);
        return toResult(map);
    }

    public String slicedProductList() {
        SDO sdo = this.getSDO();
        ProductQueryRequest queryRequest = sdo.toQueryRequest(ProductQueryRequest.class);
        return toResult(productService.slicedProductList(queryRequest));
    }

    public String forwardProduct() {
        return forward("product");
    }

    public String forwardProductDetail() {
        ObjectMapper objectMapper = new ObjectMapper();
        SDO sdo = this.getSDO();
        String str = sdo.getString("data");
        HashMap<String, Object> param = new HashMap<>();
        if (StringUtil.isNotBlank(str)) {
            try {
                param = objectMapper.readValue(str, new TypeReference<HashMap<String, Object>>() {
                });
            } catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return forward("productDetail2", param);
    }

    public String forwardProductDetail2() {
        SDO sdo = this.getSDO();
        String productId = sdo.getString("productId");
        ProductAllDataVo productAllDataVo = productService.findProductAllData(productId);
        return forward("productDetail2", productAllDataVo);
    }

    public String loadProductDetail() {
        SDO sdo = this.getSDO();
        Product product = new Product();
        String data = sdo.getString("data");
        if (StringUtil.isNotBlank(data)) {
            try {
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                product = objectMapper.readValue(data + "", Product.class);
            } catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        Map<String, Object> resultMap = new HashMap<>();
        if (product.getProductId() != null) {
            resultMap = productService.queryDetailAll(product);
        }
        return toResult(resultMap);
    }

    public String saveOrUpdateOnAllDetail() throws JsonProcessingException {
        SDO sdo = this.getSDO();
        String productId = sdo.getString("productId");
        HashMap<String, Object> newData;
        try {
            newData = objectMapper.readValue(sdo.getString("data"), new TypeReference<HashMap<String, Object>>() {
            });
            newData.put("productId", productId);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, Object> resultMap = productService.saveOrUpdataOnAllDetail(newData);
        return success(resultMap);
    }

    public String queryProcessbyTechnologyId() {
        SDO sdo = this.getSDO();
        String technologyId = sdo.getString("productTechnologyId");
        List<ProductProcess> list = processService.queryProcessbyTechnologyId(technologyId);

        return success(list);
    }

    @SkipAuth
    public String queryProductList() {
        HashMap<String, Object> aa = productService.queryProductList();
        String json = "";
        try {
            json = objectMapper.writeValueAsString(aa);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return success(json);
    }

    public String saveProduct() {
        SDO sdo = this.getSDO();
        Product product = sdo.toObject(Product.class);
        ProductDetail productDetail = sdo.toObject(ProductDetail.class);
        ProductFace productFace = sdo.toObject(ProductFace.class);
        ProductLooked productLooked = sdo.toObject(ProductLooked.class);
        ProductPublishedConf productPublishedConf = sdo.toObject(ProductPublishedConf.class);
        ProductTechnology productTechnology = sdo.toObject(ProductTechnology.class);

        List<ProductLoss> lossList = sdo.getList("lossList", ProductLoss.class);
        List<ProductProcess> processList = sdo.getList("processList", ProductProcess.class);
        List<ProductFaceColor> frontFaceColorList = sdo.getList("frontFaceColorList", ProductFaceColor.class);
        List<ProductFaceColor> backFaceColorList = sdo.getList("backFaceColorList", ProductFaceColor.class);
        List<ProductMaterial> productMaterialList = sdo.getList("productMaterialList", ProductMaterial.class);
        Map<String, Object> map = productService.saveProductAllData(product, productDetail, productFace, productLooked, productPublishedConf, productTechnology,
                lossList, processList, frontFaceColorList, backFaceColorList, productMaterialList);
        return success(map);
    }

    public String slicedFrontColorList() {
        SDO sdo = this.getSDO();
        ProductQueryRequest queryRequest = sdo.toQueryRequest(ProductQueryRequest.class);
        return toResult(productFaceColorApplication.slicedProductFaceColorList(queryRequest));
    }

    public String slicedProductProcessList() {
        SDO sdo = this.getSDO();
        ProductQueryRequest queryRequest = sdo.toQueryRequest(ProductQueryRequest.class);
        return toResult(productProcessApplication.slicedProductProcessList(queryRequest));
    }

    public String slicedProductLossList() {
        SDO sdo = this.getSDO();
        ProductQueryRequest queryRequest = sdo.toQueryRequest(ProductQueryRequest.class);
        return toResult(productLossApplication.slicedProductLossList(queryRequest));
    }

    public String slicedProductMaterialList() {
        SDO sdo = this.getSDO();
        ProductQueryRequest queryRequest = sdo.toQueryRequest(ProductQueryRequest.class);
        return toResult(productMaterialApplication.slicedProductMaterialList(queryRequest));
    }

    public String deleteFaceColor() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        productFaceColorApplication.deleteFaceColor(ids);
        return success();
    }

    public String deleteProductLoss() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        productLossApplication.deleteProductLoss(ids);
        return success();
    }

    public String deleteProductMaterial() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        productMaterialApplication.deleteProductMaterial(ids);
        return success();
    }

    public String updateAProductStatus() {

        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        String  status = sdo.getString("status");
        productService.updateAProductStatus(ids,status);
        return success();
    }

    public String ConversionToOfficialProducts(){
        SDO sdo = this.getSDO();
        String ids = sdo.getString("ids");
        productService.ConversionToOfficialProducts(ids);
        return success();
    }
}

//// 通过此方法可以查看系统配置的 字典 的数据结构
//        DictUtil.getDictionaryList("technologyType");
//                Map<String, Object> map4 = new HashMap<>(10);
//        map4.put("六六六", "666");
//        map4.put("七七七", "777");
//        map4.put("八八八", "888");