package com.huigou.topsun.product.application.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.product.application.ProductProcessApplication;
import com.huigou.topsun.product.domain.ProductProcess;
import com.huigou.topsun.product.domain.query.ProductQueryRequest;
import com.huigou.topsun.product.repository.ProductProcessRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
@author qinzhenguan
*/
@Service
@RequiredArgsConstructor
public class ProductProcessApplicationImpl extends BaseApplication implements ProductProcessApplication  {

	private final  ProductProcessRepository processRepository;
	private final ObjectMapper objectMapper;


	@Override
	public List<ProductProcess> queryProcessbyTechnologyId(String technologyId) {
		ArrayList<ProductProcess> processList = new ArrayList<>();
		
		if(technologyId != null) {
			processList = (ArrayList<ProductProcess>) processRepository.findByProductTechnologyId(technologyId);
		}
		if(processList.size() == 0) {
			ProductProcess fc = new ProductProcess();
			fc.setProductTechnologyId("556");
			fc.setProductProcessId("111");
			fc.setProductionSequence(1);
			processList .add(fc);
		}
		return processList;
	}

	@Override
	public void saveProductProcessList(String productTechnologyId, List<ProductProcess> productProcessList) {
		//先删除在保存
		List<ProductProcess> processList = processRepository.findByProductTechnologyId(productTechnologyId);
		processRepository.delete(processList);
		productProcessList.forEach(productProcess -> {
			productProcess.setProductTechnologyId(productTechnologyId);
			processRepository.save(productProcess);
		});
	}

	@Override
	public Map<String, Object> slicedProductProcessList(ProductQueryRequest queryRequest) {
		Map<String,Object> map = new HashMap<>();
		if (StringUtil.isNotBlank(queryRequest.getProductTechnologyId())){
			QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "productProcessList");
			QueryModel model = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
			map = this.sqlExecutorDao.executeSlicedQuery(model);
		}
		return map;
	}
}
