package com.huigou.topsun.product.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.product.application.ProductMaterialApplication;
import com.huigou.topsun.product.domain.ProductMaterial;
import com.huigou.topsun.product.domain.query.ProductQueryRequest;
import com.huigou.topsun.product.repository.ProductMaterialRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 16508
 * @description 针对表【product_material(产品物料组成)】的数据库操作Service实现
 * @createDate 2023-11-22 10:24:31
 */
@Service
public class ProductMaterialApplicationImpl extends BaseApplication implements ProductMaterialApplication {
    @Resource
    private ProductMaterialRepository productMaterialRepository;

    @Override
    public Map<String, Object> slicedProductBom(String productId) {
        Map<String, Object> map = new HashMap<>();
        List<ProductMaterial> byProductId = productMaterialRepository.findByProductId(productId);
        ArrayList<HashMap<String, Object>> productBoms = new ArrayList<>();
        for (ProductMaterial productMaterial : byProductId) {
            HashMap<String, Object> rowMap = new HashMap<>();
            rowMap.put("ALPGR", productMaterial.getMaterialAlpgr());
            rowMap.put("materialName", productMaterial.getMaterialName());
            rowMap.put("materialNumber", productMaterial.getMaterialNumber());
            rowMap.put("AUSCH", productMaterial.getMaterialAusch());
            rowMap.put("POTX1", productMaterial.getMaterialPotx1());
            rowMap.put("materialJson", productMaterial.getMaterialJson());
            rowMap.put("ALPRF", productMaterial.getMaterialAlprf());
            rowMap.put("ALPST", productMaterial.getMaterialAlpst());
            rowMap.put("EWAHR", productMaterial.getMaterialEwahr());
            rowMap.put("materialId", productMaterial.getMaterialId());
            rowMap.put("materialUnit", productMaterial.getMaterialUnit());
            rowMap.put("bomId", productMaterial.getProductMaterialId());
            rowMap.put("primaryKey", productMaterial.getProductId());
            rowMap.put("ITEM_NUMBRE",productMaterial.getMaterialItemNumber());
            rowMap.put("CATEGORY",productMaterial.getMaterialCategory());
            rowMap.put("PROCURE",productMaterial.getMaterialProcure());
            rowMap.put("NOTE",productMaterial.getMaterialNote());
            productBoms.add(rowMap);
        }
        map.put("Total", byProductId.size());
        map.put("page", 1);
        map.put("Rows", productBoms);
        return map;
    }

    @Override
    public void saveProductMaterial(String productId, List<ProductMaterial> productMaterialList) {
        productMaterialList.forEach(productMaterial -> {
            productMaterial.setProductId(productId);
            productMaterialRepository.save(productMaterial);
        });
    }

    @Override
    public Map<String, Object> slicedProductMaterialList(ProductQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getProductId())) {
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "productMaterialList");
            QueryModel model = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(model);
        }
        return map;
    }

    @Override
    public void deleteProductMaterial(List<String> ids) {
        ids.forEach(id -> {
            productMaterialRepository.delete(id);
        });
    }
}




