package com.huigou.topsun.product.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.product.application.ProductLossApplication;
import com.huigou.topsun.product.domain.ProductLoss;
import com.huigou.topsun.product.domain.query.ProductQueryRequest;
import com.huigou.topsun.product.repository.ProductLossRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* @author 16508
* @description 针对表【product_loss(产品loss配置)】的数据库操作Service实现
* @createDate 2023-11-22 10:24:31
*/
@Service
public class ProductLossApplicationImpl extends BaseApplication implements ProductLossApplication {

    @Resource
    private ProductLossRepository productLossRepository;
    @Override
    public void saveProductLossList(String productId, List<ProductLoss> productLossList) {
        productLossList.forEach(productLoss -> {
            productLoss.setProductId(productId);
            productLossRepository.save(productLoss);
        });
    }

    @Override
    public Map<String, Object> slicedProductLossList(ProductQueryRequest queryRequest) {
        Map<String,Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getProductId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "productLossList");
            QueryModel model = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(model);
        }
        return map;
    }

    @Override
    public void deleteProductLoss(List<String> ids) {
        ids.forEach(id->{
            productLossRepository.delete(id);
        });
    }
}




