package com.huigou.topsun.product.application.impl;

import com.huigou.topsun.product.application.ProductLookedApplication;
import com.huigou.topsun.product.domain.ProductLooked;
import com.huigou.topsun.product.domain.ProductLoss;
import com.huigou.topsun.product.repository.ProductLookedRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.stereotype.Service;

/**
* @author 16508
* @description 针对表【product_looked(产品外观)】的数据库操作Service实现
* @createDate 2023-11-22 10:24:31
*/
@Service
public class ProductLookedApplicationImpl implements ProductLookedApplication {

    @Autowired
    ProductLookedRepository productLookedRepository;


    @Override
    public ProductLooked getProductLookedByEntity(ProductLooked productLooked) {
        ExampleMatcher matcher = ExampleMatcher.matching();
        // 构建 Example 对象
        Example<ProductLooked> example = Example.of(productLooked, matcher);
        return  productLookedRepository.findOne(example);
    }

    @Override
    public ProductLooked saveProductLooked(String productId, ProductLooked productLooked) {
        productLooked.setProductId(productId);
        return productLookedRepository.save(productLooked);
    }
}




