package com.huigou.topsun.product.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.product.application.ProductFaceColorApplication;
import com.huigou.topsun.product.domain.ProductFaceColor;
import com.huigou.topsun.product.domain.query.ProductQueryRequest;
import com.huigou.topsun.product.repository.ProductFaceColorRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* @author 16508
* @description 针对表【product_face_color(产品版面颜色)】的数据库操作Service实现
* @createDate 2023-11-22 10:24:31
*/
@Service
public class ProductFaceColorApplicationImpl extends BaseApplication implements ProductFaceColorApplication {
    @Resource
    private ProductFaceColorRepository productFaceColorRepository;

    @Override
    public void saveProductFaceColorList(String productId, List<ProductFaceColor> productFaceColorList) {
        productFaceColorList.forEach(productFaceColor -> {
            productFaceColor.setProductId(productId);
            productFaceColorRepository.save(productFaceColor);
        });
    }

    @Override
    public Map<String, Object> slicedProductFaceColorList(ProductQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getProductId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "productFaceColorList");
            QueryModel model = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(model);
        }
        return map;
    }

    @Override
    public void deleteFaceColor(List<String> ids) {
        ids.forEach(id->{
            productFaceColorRepository.delete(id);
        });
    }

}




