package com.huigou.topsun.product.application.impl;

import com.huigou.topsun.product.application.ProductDetailApplication;
import com.huigou.topsun.product.domain.ProductDetail;
import com.huigou.topsun.product.repository.ProductDetailRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
* @author 16508
* @description 针对表【product_detail(产品详细信息)】的数据库操作Service实现
* @createDate 2023-11-22 10:24:31
*/
@Service
public class ProductDetailApplicationImpl extends BaseApplication implements ProductDetailApplication {

    @Resource
    private ProductDetailRepository productDetailRepository;

    @Override
    public ProductDetail saveProductDetail(String productId, ProductDetail productDetail) {
        productDetail.setProductId(productId);
        return productDetailRepository.save(productDetail);
    }

    @Override
    public ProductDetail findByProductId(String productId) {
        return productDetailRepository.findByProductId(productId);
    }
}




