package com.huigou.topsun.product.application;


import com.huigou.topsun.product.domain.*;
import com.huigou.topsun.product.domain.query.ProductQueryRequest;
import com.huigou.topsun.product.domain.vo.ProductAllDataVo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 16508
 * @description 针对表【product(产品)】的数据库操作Service
 * @createDate 2023-11-22 10:24:31
 */
public interface ProductApplication {
    public static final String QUERY_XML_FILE_PATH = "config/topsun/product/product.xml";

    /**
     * description 查询产品列表
     * @param page 当前页
     * @param size 页大小
     * @return org.springframework.data.domain.Page<com.huigou.topsun.product.domain.Product>
     * @author qinzhenguan
     * @createDate 2023/11/29 9:34
     */
    ArrayList<Map<String, Object>> findProductPage(int page, int size);

    /**
     * description  获取产品所有信息
     * @param product 产品
     * @return java.util.Map<java.lang.String, java.lang.Object>
     * @author qinzhenguan
     * @createDate 2023/11/29 9:33
     */
    Map<String, Object> queryDetailAll(Product product);

    /**
     * description  对比所有对象，并保存更改的数据。
     *
     * @param newData 更新数据
     * @return java.util.HashMap<java.lang.String, java.lang.Object>
     * @author qinzhenguan
     * @createDate 2023/12/8 17:19
     */
    HashMap<String, Object> saveOrUpdataOnAllDetail(HashMap<String, Object> newData);

    HashMap<String, Object> queryProductList();

    /**
     * 保存产品基本信息
     * @param product
     * @return
     */
    Product saveProduct(Product product);

    ProductAllDataVo findProductAllData(String productId);

    Map<String, Object> saveProductAllData(Product product, ProductDetail productDetail, ProductFace productFace, ProductLooked productLooked, ProductPublishedConf productPublishedConf, ProductTechnology productTechnology, List<ProductLoss> lossList, List<ProductProcess> processList, List<ProductFaceColor> frontFaceColorList, List<ProductFaceColor> backFaceColorList, List<ProductMaterial> productMaterialList);

    Map<String,Object> slicedProductList(ProductQueryRequest queryRequest);

    void updateAProductStatus(List<String> ids, String  status);

    void ConversionToOfficialProducts(String ids);
}
