package com.huigou.topsun.customer.domain.vo;

import com.alibaba.fastjson.JSON;
import com.huigou.topsun.customer.domain.CustomerPayInfo;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * title:
 * author:ZHT
 * date:2023/12/19
 * description:
 */
@Data
public class CustomerPayInfoVo implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 客户付款信息表id
     */
    private String customerPayInfoId;

    /**
     * 客户id
     */
    private String customerId;

    /**
     * 支付方户名
     */
    private String customerPayAccountName;

    /**
     * 录入人
     */
    private String createdByName;

    /**
     * 录入人id
     */
    private String createdById;

    /**
     * 录入时间
     */
    private Date createdDate;

    /**
     * 修改人id
     */
    private String lastModifiedById;

    /**
     * 修改人
     */
    private String lastModifiedByName;

    /**
     * 修改日期
     */
    private Date lastModifiedDate;

    public static CustomerPayInfo getCustomerPayInfo(CustomerPayInfoVo customerPayInfoVo){
        return JSON.parseObject(JSON.toJSONString(customerPayInfoVo),CustomerPayInfo.class);
    }

    public static CustomerPayInfoVo getCustomerPayInfoVo(CustomerPayInfo customerPayInfo){
        return JSON.parseObject(JSON.toJSONString(customerPayInfo),CustomerPayInfoVo.class);
    }
}
