package com.huigou.topsun.customer.domain.sap.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import java.io.Serializable;
import java.util.List;

@Data
public class SapCustomerDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 客户编码
     */
    @JsonProperty(value = "KUNNR")
    private String customerCode;

    /**
     * 客户全称
     */
    @JsonProperty(value = "NAME1")
    private String customerName;

    /**
     * 客户简称
     */
    @JsonProperty(value = "BU_SORT1")
    private String customerShortName;

    /**
     * 客户工作时间
     */
    @JsonProperty(value = "ZT02")
    private String customerWorkTime;


    /**
     * 所属集团
     */
    @JsonProperty(value = "ZCLIQUE")
    private String customerGroup;

    /**
     * 邮编
     */
    @JsonProperty(value = "POST_CODE1")
    private String customerZipCode;

    /**
     * 账户组
     */
    @JsonProperty(value = "BU_GROUP")
    private String customerAccountGroup;

    /**
     * 业务伙伴角色
     */
    @JsonProperty(value = "RLTYP")
    private String customerBusinessPartnerRole;

    /**
     * 开票地址
     */
    @JsonProperty(value = "STRAS")
    private String customerBillingAddress;

    /**
     * 客户送货地址(固定)
     */
    @JsonProperty(value = "STR_SUPPL3")
    private String customerDeliveryAddress;

    /**
     * 国家
     */
    @JsonProperty(value = "LAND1")
    private String customerCountry;

    /**
     * 城市
     */
    @JsonProperty(value = "CITY1")
    private String customerCity;

    /**
     * 地区
     */
    @JsonProperty(value = "REGIO")
    private String customerRegion;

    /**
     * 语言
     */
    @JsonProperty(value = "SPRAS")
    private String customerLanguage;

    /**
     * 电话号码
     */
    @JsonProperty(value = "TEL_NUMBER")
    private String customerTelNumber;

    /**
     * 移动电话
     */
    @JsonProperty(value = "MOB_NUMBER")
    private String customerMobNumber;

    /**
     * 邮箱地址
     */
    @JsonProperty(value = "SMTP_ADDR")
    private String customerSmtpAddr;

    /**
     * 送货单打印默认设置
     */
    @JsonProperty(value = "ZF12")
    private String defaultSettingsOfPrintingDeliveryNotes;

    /**
     * 品牌列表
     */
    @JsonProperty(value = "brandList")
    private List<SapCustomerBrandDto> sapCustomerBrandDtoList;

    /**
     * 银行列表
     */
    @JsonProperty(value = "bankList")
    private List<SapCustomerBankDto> sapCustomerBankDtoList;

    //公司代码字段
    /**
     * 公司代码
     */
    @JsonProperty(value = "BUKRS")
    private String companyCode;

    /**
     * 统驭科目
     */
    @JsonProperty(value = "AKONT")
    private String reconciliationAccount;

    /**
     * 付款条件
     */
    @JsonProperty(value = "company_ZTERM")
    private String companyPaymentTerms;

    /**
     * 催款过程
     */
    @JsonProperty(value = "MAHNA")
    private String collectionProcess;

    //销售组织字段
    /**
     * 销售组织
     */
    @JsonProperty(value = "VKORG")
    private String organization;

    /**
     * 分销渠道
     */
    @JsonProperty(value = "VTWEG")
    private String distributionChannel;

    /**
     * 产品组
     */
    @JsonProperty(value = "SPART")
    private String productGroup;

    /**
     * 销售办公室
     */
    @JsonProperty(value = "VKBUR")
    private String salesOffice;

    /**
     * 销售小组
     */
    @JsonProperty(value = "VKGRP")
    private String salesGroup;

    /**
     * 客户等级（客户分类）
     */
    @JsonProperty(value = "KLABC")
    private String customerGrade;

    /**
     * 币别
     */
    @JsonProperty(value = "WAERK")
    private String currency;
    /**
     * 汇率类型
     */
    @JsonProperty(value = "KURST")
    private String exchangeRate;
    /**
     * 国际贸易条款
     */
    @JsonProperty(value = "INCO1")
    private String incoterm;
    /**
     * 国际贸易条款位置
     */
    @JsonProperty(value = "INCO2")
    private String incotermPosition;
    /**
     * 付款条件
     */
    @JsonProperty(value = "sales_ZTERM")
    private String salesPaymentTerms;
    /**
     * 客户科目分配组
     */
    @JsonProperty(value = "KTGRD")
    private String customerAccountAllocationGroup;
    /**
     * 税收类别
     */
    @JsonProperty(value = "TATYP")
    private String taxCategory;
    /**
     * 客户税分类
     */
    @JsonProperty(value = "TAXKD")
    private String customerTaxClassification;
    /**
     * 装运条件
     */
    @JsonProperty(value = "VSBED")
    private String shippingConditions;

}
