package com.huigou.topsun.customer.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 
 * @TableName customer_sales_organization
 */
@Table(name="customer_sales_organization")
@Data
@Entity
public class CustomerSalesOrganization implements Serializable {
    /**
     * 销售组织id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "customer_sales_organization_id")
    private String customerSalesOrganizationId;

    /**
     * 客户id
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 销售组织
     */
    private String organization;

    /**
     * 分销渠道
     */
    @Column(name = "distribution_channel")
    private String distributionChannel;

    /**
     * 产品组
     */
    @Column(name = "product_group")
    private String productGroup;

    /**
     * 销售办公室
     */
    @Column(name = "sales_office")
    private String salesOffice;

    /**
     * 销售小组
     */
    @Column(name = "sales_group")
    private String salesGroup;

    /**
     * 客户等级(客户分类)
     */
    @Column(name = "customer_grade")
    private String customerGrade;

    /**
     * 币别
     */
    private String currency;

    /**
     * 汇率类型
     */
    @Column(name = "exchange_rate")
    private String exchangeRate;

    /**
     * 国际贸易条款
     */
    private String incoterm;

    /**
     * 国际贸易条款位置
     */
    @Column(name = "incoterm_position")
    private String incotermPosition;

    /**
     * 付款条件
     */
    @Column(name = "sales_payment_terms")
    private String salesPaymentTerms;

    /**
     * 客户科目分配组
     */
    @Column(name = "customer_account_allocation_group")
    private String customerAccountAllocationGroup;

    /**
     * 税收类别
     */
    @Column(name = "tax_category")
    private String taxCategory;

    /**
     * 客户税分类
     */
    @Column(name = "customer_tax_classification")
    private String customerTaxClassification;

    /**
     * 装运条件
     */
    @Column(name = "shipping_conditions")
    private String shippingConditions;

    private static final long serialVersionUID = 1L;
}