package com.huigou.topsun.customer.domain;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 催货款通知邮箱
 * @TableName customer_debt_contact
 */
@Table(name="customer_debt_contact")
@Entity
@Data
public class CustomerDebtContact implements Serializable {
    /**
     * 催货款通知邮箱id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "customer_debt_contact_id")
    private String customerDebtContactId;

    /**
     * 客户id
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 邮箱地址
     */
    @Column(name = "customer_email")
    private String customerEmail;

    /**
     * 联系人
     */
    @Column(name = "customer_contact")
    private String customerContact;

    /**
     * 是否开启邮件发送
     */
    @Column(name = "send_email")
    private String sendEmail;

    /**
     * 邮箱类型（customerEmailType）-（宝绅邮箱、客户邮箱）
     */
    @Column(name = "customer_email_type")
    private String customerEmailType;

    /**
     * 创建人id
     */
    @Column(name = "created_by_id")
    private String createdById;

    /**
     * 创建人名称
     */
    @Column(name = "created_by_name")
    private String createdByName;

    /**
     * 创建日期
     */
    @Column(name = "created_date")
    private Date createdDate;

    private static final long serialVersionUID = 1L;
}