package com.huigou.topsun.customer.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 客户联系人信息
 *
 * @TableName customer_contact
 */
@Table(name = "customer_contact")
@Data
@Entity
public class CustomerContact implements Serializable {
    /**
     * 客户联系人id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "customer_contact_id")
    private String customerContactId;

    /**
     * 客户id
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 联系人名称
     */
    @Column(name = "contact_name")
    private String contactName;

    /**
     * 职位
     */
    @Column(name = "contact_position")
    private String contactPosition;

    /**
     * 联系人电话
     */
    @Column(name = "contact_phone")
    private String contactPhone;

    /**
     * 传真
     */
    @Column(name = "contact_fax")
    private String contactFax;

    /**
     * 邮件
     */
    @Column(name = "contact_email")
    private String contactEmail;


    private static final long serialVersionUID = 1L;
}