package com.huigou.topsun.customer.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 
 * @TableName customer_company_code
 */
@Table(name="customer_company_code")
@Data
@Entity
public class CustomerCompanyCode implements Serializable {
    /**
     * 公司代码id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "company_code_id")
    private String companyCodeId;

    /**
     * 客户id
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 公司代码
     */
    @Column(name = "company_code")
    private String companyCode;

    /**
     * 统驭科目
     */
    @Column(name = "reconciliation_account")
    private String reconciliationAccount;

    /**
     * 付款条件
     */
    @Column(name = "company_payment_terms")
    private String companyPaymentTerms;

    /**
     * 催款过程
     */
    @Column(name = "collection_process")
    private String collectionProcess;

    private static final long serialVersionUID = 1L;
}