package com.huigou.topsun.customer.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 
 * @TableName customer_brand
 */
@Table(name="customer_brand")
@Data
@Entity
public class CustomerBrand implements Serializable {
    /**
     * 品牌id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "brand_id")
    private String brandId;

    /**
     * 客户id
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 品牌
     */
    private String brand;

    /**
     * 职位
     */
    private String position;

    /**
     * 联系人
     */
    private String contact;

    /**
     * 电话号码
     */
    private String tel;

    /**
     * e_Mail
     */
    @Column(name = "e_mail")
    private String eMail;

    /**
     * 经营类型
     */
    @Column(name = "operate_type")
    private String operateType;

    /**
     * 工厂代号
     */
    @Column(name = "factory_code")
    private String factoryCode;

    /**
     * 跟单员
     */
    private String merchandiser;

    private static final long serialVersionUID = 1L;
}