package com.huigou.topsun.customer.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 
 * @TableName customer_bank_list
 */
@Table(name="customer_bank_list")
@Data
@Entity
public class CustomerBankList implements Serializable {
    /**
     * 客户银行信息列表id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "customer_bank_list_id")
    private String customerBankListId;

    /**
     * 客户id
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 开户银行代码
     */
    @Column(name = "deposit_bank_code")
    private String depositBankCode;

    /**
     * 银行账户
     */
    @Column(name = "bank_account")
    private String bankAccount;

    /**
     * 参考明细
     */
    @Column(name = "reference_details")
    private String referenceDetails;

    private static final long serialVersionUID = 1L;
}