package com.huigou.topsun.customer.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 客户基础信息
 * @TableName customer
 */
@Table(name="customer")
@Data
@Entity
public class Customer implements Serializable {
    /**
     * 客户id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 客户编码
     */
    @Column(name = "customer_code")
    private String customerCode;

    /**
     * 客户全称
     */
    @Column(name = "customer_name")
    private String customerName;

    /**
     * 客户简称
     */
    @Column(name = "customer_short_name")
    private String customerShortName;

    /**
     * 客户工作时间
     */
    @Column(name = "customer_work_time")
    private String customerWorkTime;

    /**
     * 客户英文名称
     */
    @Column(name = "customer_en_name")
    private String customerEnName;

    /**
     * 客户英文名称简称
     */
    @Column(name = "customer_en_short_name")
    private String customerEnShortName;

    /**
     * 省份编码
     */
    @Column(name = "province_code")
    private String provinceCode;

    /**
     * 客户等级
     */
    @Column(name = "customer_level")
    private String customerLevel;

    /**
     * 工厂代号
     */
    @Column(name = "customer_factory_code")
    private String customerFactoryCode;

    /**
     * 地址
     */
    @Column(name = "customer_address")
    private String customerAddress;

    /**
     * 所属集团
     */
    @Column(name = "customer_group")
    private String customerGroup;

    /**
     * 邮编
     */
    @Column(name = "customer_zip_code")
    private String customerZipCode;

    /**
     * 账户组
     */
    @Column(name = "customer_account_group")
    private String customerAccountGroup;

    /**
     * 业务伙伴角色
     */
    @Column(name = "customer_business_partner_role")
    private String customerBusinessPartnerRole;

    /**
     * 开票地址
     */
    @Column(name = "customer_billing_address")
    private String customerBillingAddress;

    /**
     * 客户送货地址(固定)
     */
    @Column(name = "customer_delivery_address")
    private String customerDeliveryAddress;

    /**
     * 国家
     */
    @Column(name = "customer_country")
    private String customerCountry;

    /**
     * 城市
     */
    @Column(name = "customer_city")
    private String customerCity;

    /**
     * 地区
     */
    @Column(name = "customer_region")
    private String customerRegion;

    /**
     * 语言
     */
    @Column(name = "customer_language")
    private String customerLanguage;

    /**
     * 电话号码
     */
    @Column(name = "customer_tel_number")
    private String customerTelNumber;

    /**
     * 移动电话
     */
    @Column(name = "customer_mob_number")
    private String customerMobNumber;

    /**
     * 邮箱地址
     */
    @Column(name = "customer_smtp_addr")
    private String customerSmtpAddr;

    /**
     * 送货单打印默认设置
     */
    @Column(name = "default_settings_of_printing_delivery_notes")
    private String defaultSettingsOfPrintingDeliveryNotes;

    private static final long serialVersionUID = 1L;
}