package com.huigou.topsun.customer.controller;

import com.huigou.topsun.customer.application.CustomerSalesOrganizationApplication;
import com.huigou.topsun.customer.domain.CustomerBankList;
import com.huigou.topsun.customer.domain.CustomerSalesOrganization;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;

@Controller
@ControllerMapping("/customerSalesOrganization")
public class CustomerSalesOrganizationController extends CommonController {
    @Autowired
    private CustomerSalesOrganizationApplication customerSalesOrganizationApplication;

    public String slicedCustomerSalesOrganizationList() {
        SDO sdo = getSDO();
        String customerId = sdo.getString("customerId");
        List<CustomerSalesOrganization> customerSalesOrganizationList = customerSalesOrganizationApplication.getCustomerSalesOrganizationList(customerId);
        return packGridDataAndResult(customerSalesOrganizationList);
    }

}
