package com.huigou.topsun.customer.controller;

import com.huigou.topsun.customer.application.CustomerCompanyCodeApplication;
import com.huigou.topsun.customer.domain.CustomerBankList;
import com.huigou.topsun.customer.domain.CustomerCompanyCode;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;

@Controller
@ControllerMapping("/customerCompanyCode")
public class CustomerCompanyCodeController extends CommonController {
    @Autowired
    private CustomerCompanyCodeApplication customerCompanyCodeApplication;


    public String slicedCustomerCompanyCodeList() {
        SDO sdo = getSDO();
        String customerId = sdo.getString("customerId");
        List<CustomerCompanyCode> customerCompanyCodeList = customerCompanyCodeApplication.getCustomerCompanyCodeList(customerId);
        return packGridDataAndResult(customerCompanyCodeList);
    }
}
