package com.huigou.topsun.customer.controller;

import com.huigou.topsun.customer.application.CustomerBrandApplication;
import com.huigou.topsun.customer.domain.CustomerBrand;
import com.huigou.topsun.customer.domain.CustomerPayInfo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;

@Controller
@ControllerMapping("/customerBrand")
public class CustomerBrandController extends CommonController {
    @Autowired
    private CustomerBrandApplication customerBrandApplication;

    public String slicedCustomerBrandList() {
        SDO sdo = this.getSDO();
        String customerId = sdo.getString("customerId");
        List<CustomerBrand> customerBrandList = customerBrandApplication.getCustomerBrandList(customerId);
        return packGridDataAndResult(customerBrandList);
    }

//    public String deleteCustomerBrand() {
//        SDO sdo = this.getSDO();
//        List<String> ids = sdo.getIds();
//        int result = customerBrandApplication.deleteCustomerBrandList(ids);
//        if (result==1) {
//            return success();
//        }
//        else {
//            return error("品牌信息删除失败");
//        }
//    }
}
