package com.huigou.topsun.customer.controller;

import com.huigou.topsun.customer.application.CustomerApplication;
import com.huigou.topsun.customer.application.CustomerBankListApplication;
import com.huigou.topsun.customer.domain.CustomerBankList;
import com.huigou.topsun.customer.domain.CustomerBrand;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;

@Controller
@ControllerMapping("/customerBankList")
public class CustomerBankListController extends CommonController {
    @Autowired
    private CustomerBankListApplication customerBankListApplication;


    public String slicedCustomerBankList() {
        SDO sdo = getSDO();
        String customerId = sdo.getString("customerId");
        List<CustomerBankList> customerBrandList = customerBankListApplication.getCustomerBankList(customerId);
        return packGridDataAndResult(customerBrandList);
    }
}
