package com.huigou.topsun.customer.application.Impl;

import cn.hutool.core.bean.BeanUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.topsun.customer.application.SapCustomerApplication;
import com.huigou.topsun.customer.domain.*;
import com.huigou.topsun.customer.domain.sap.dto.SapCustomerDto;
import com.huigou.topsun.customer.domain.vo.CustomerBankListVo;
import com.huigou.topsun.customer.domain.vo.CustomerBrandVo;
import com.huigou.topsun.customer.domain.vo.CustomerVo;
import com.huigou.uasp.bmp.common.application.AbstractApplication;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class SapCustomerApplicationImpl extends AbstractApplication implements SapCustomerApplication {



    @Override
    public String submitCustomerToSAP(CustomerVo customerVo, List<CustomerBrandVo> customerBrandList, List<CustomerBankListVo> sapCustomerBankList, CustomerCompanyCode customerCompanyCode, CustomerSalesOrganization customerSalesOrganization) {
        SapCustomerDto sapCustomerDto = new SapCustomerDto();
        if (!BeanUtil.isEmpty(customerVo)) {
            BeanUtils.copyProperties(customerVo, sapCustomerDto);
        }
        //转JSON
        ObjectMapper objectMapper = new ObjectMapper();
        String sapCustomerDtoJson;
        try {
            sapCustomerDtoJson = objectMapper.writeValueAsString(sapCustomerDto);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }



        return sapCustomerDtoJson;
    }
}
