package com.huigou.topsun.customer.application.Impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.customer.application.CustomerSalesOrganizationApplication;
import com.huigou.topsun.customer.domain.CustomerSalesOrganization;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CustomerSalesOrganizationApplicationImpl extends BaseApplication implements CustomerSalesOrganizationApplication {
    String QUERY_XML_FILE_PATH = "config/topsun/customer/customerMapper.xml";

    @Override
    public List<CustomerSalesOrganization> getCustomerSalesOrganizationList(String customerId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "customerSalesOrganizationList");
        List<CustomerSalesOrganization> customerSalesOrganizationList = this.sqlExecutorDao.queryToList(queryDescriptor.getSql(), CustomerSalesOrganization.class, customerId);
        return customerSalesOrganizationList;
    }
}
