package com.huigou.topsun.customer.application.Impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.customer.application.CustomerCompanyCodeApplication;
import com.huigou.topsun.customer.domain.CustomerBrand;
import com.huigou.topsun.customer.domain.CustomerCompanyCode;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CustomerCompanyApplicationImpl extends BaseApplication implements CustomerCompanyCodeApplication {
    String QUERY_XML_FILE_PATH = "config/topsun/customer/customerMapper.xml";
    @Override
    public List<CustomerCompanyCode> getCustomerCompanyCodeList(String customerId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "customerCompanyCodeList");
        List<CustomerCompanyCode> customerCompanyCodeList = this.sqlExecutorDao.queryToList(queryDescriptor.getSql(), CustomerCompanyCode.class, customerId);
        return customerCompanyCodeList;
    }
}
