package com.huigou.topsun.customer.application.Impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.customer.application.CustomerBrandApplication;
import com.huigou.topsun.customer.domain.CustomerBrand;
import com.huigou.topsun.customer.domain.CustomerPayInfo;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CustomerBrandApplicationImpl extends BaseApplication implements CustomerBrandApplication {
    String QUERY_XML_FILE_PATH = "config/topsun/customer/customerMapper.xml";
    @Override
    public List<CustomerBrand> getCustomerBrandList(String customerId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "customerBrandList");
        List<CustomerBrand> customerBrandList = this.sqlExecutorDao.queryToList(queryDescriptor.getSql(), CustomerBrand.class, customerId);
        return customerBrandList;
    }
}
