package com.huigou.topsun.customer.application.Impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.customer.application.CustomerBankListApplication;
import com.huigou.topsun.customer.domain.CustomerBankList;
import com.huigou.topsun.customer.domain.CustomerBrand;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CustomerBankListApplicationImpl extends BaseApplication implements CustomerBankListApplication {
    String QUERY_XML_FILE_PATH = "config/topsun/customer/customerMapper.xml";
    @Override
    public List<CustomerBankList> getCustomerBankList(String customerId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "customerBankList");
        List<CustomerBankList> customerBankList = this.sqlExecutorDao.queryToList(queryDescriptor.getSql(), CustomerBankList.class, customerId);
        return customerBankList;
    }
}
