package com.huigou.topsun.base.bsnMessage.domain;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * @TableName bsn_message
 */
@Table(name="bsn_message")
@Entity
@Data
public class BsnMessage implements Serializable {
    /**
     * id
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    private String id;

    /**
     * 任务描述
     */
    private String title;

    /**
     * 任务发起人
     */
    @Column(name="task_sponsor")
    private String taskSponsor;

    /**
     * 任务发起人
     */
    @Column(name="task_describe")
    private String taskDescribe;


    /**
     * 任务执行人
     */
    private String listners;

    /**
     * 业务应用类型
     */
    @Column(name = "business_code")
    private String businessCode;

    /**
     * 业务表单id
     */
    @Column(name = "business_id")
    private String businessId;

    /**
     * 创建日期
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 完成日期
     */
    @Column(name = "finished_date")
    private Date finishedDate;

    /**
     *任务执行地址
     */
    @Column(name = "executor_url")
    private String executorUrl;

    /**
     * 完成状态（默认为未完成：0，完成为：1，保存未分发：2）
     */
    private Integer active;

    private static final long serialVersionUID = 1L;
}