package com.huigou.topsun.base.bsnMessage.appliction.impl;

import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.exception.ApplicationException;
import com.huigou.topsun.base.bsnMessage.appliction.BsnMessageApplication;
import com.huigou.topsun.base.bsnMessage.domain.BsnMessage;
import com.huigou.topsun.base.bsnMessage.domain.query.BsnMessageQueryRequest;
import com.huigou.topsun.base.bsnMessage.repository.BsnMessageRepository;
import com.huigou.topsun.base.coderule.application.CodeRuleApplication;
import com.huigou.topsun.base.coderule.domain.model.CodeRule;
import com.huigou.topsun.base.coderule.domain.model.CodeRuleKind;
import com.huigou.topsun.base.coderule.domain.query.CodeRuleQueryRequest;
import com.huigou.topsun.base.coderule.repository.CodeRuleRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.uasp.bmp.opm.domain.model.org.Org;
import com.huigou.uasp.bmp.opm.proxy.OrgApplicationProxy;
import com.huigou.util.ApplicationContextWrapper;
import com.huigou.util.DateUtil;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 采购编号及合同编号编码规则
 * 
 * @ClassName: CodeRuleApplicationImpl
 * @author
 * @date 2018-06-20 15:20
 * @version V1.0
 */
@Service("bsnMessageApplication")
public class BsnMessageApplicationImpl extends BaseApplication implements BsnMessageApplication {

    @Autowired
    BsnMessageRepository bsnMessageRepository;

    @Override
    public Map<String, Object> queryBsnMessage() {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "queryBsnMessage");
        QueryModel queryModel = new QueryModel();
        queryModel.setSql(queryDescriptor.getSql());
        queryModel.setPageIndex(1);
        queryModel.setPageSize(10);
        queryModel.setSortFieldName("createDate");
        queryModel.setSortOrder("desc");
        queryModel.putParam("listners", this.getOperator().getUserId());
        return this.sqlExecutorDao.executeSlicedQuery(queryModel);
    }

    @Override
    public List<Map<String,Object>> queryFinishBsnMessage() {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "queryFinishBsnMessage");
        QueryModel queryModel = new QueryModel();
        queryModel.setSql(queryDescriptor.getSql());
        queryModel.setPageIndex(1);
        queryModel.setPageSize(10);
        queryModel.setSortFieldName("createDate");
        queryModel.setSortOrder("desc");
        queryModel.putParam("taskSponsor", this.getOperator().getUserId());
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        return (List<Map<String,Object>>)map.get("Rows");
    }

    @Override
    public List<BsnMessage> getBsnMessageByBusinessId(String businessId) {
        return  bsnMessageRepository.findAllByBusinessId(businessId);
    }

    @Override
    public List<BsnMessage> getBsnMessageByListner(String listner) {
        return  bsnMessageRepository.findAllByListners(listner);
    }
    @Override
    public void saveBsnMessage(List<BsnMessage> bsnMessages) {
        bsnMessageRepository.save(bsnMessages);
    }
}
