package com.huigou.topsun.base;

import com.huigou.context.Operator;
import com.huigou.topsun.base.bsnMessage.appliction.BsnMessageApplication;
import com.huigou.topsun.base.bsnMessage.domain.ActiveStatus;
import com.huigou.topsun.base.bsnMessage.domain.BsnMessage;
import com.huigou.uasp.bmp.opm.application.OrgApplication;
import com.huigou.uasp.bpm.BatchAdvanceParameter;
import com.huigou.uasp.bpm.TaskStatus;
import com.huigou.uasp.bpm.engine.application.ActApplication;
import com.huigou.uasp.bpm.engine.application.ProcUnitHandlerApplication;
import com.huigou.uasp.bpm.engine.application.impl.WorkflowApplicationImpl;
import com.huigou.uasp.bpm.engine.domain.model.CoordinationTask;
import com.huigou.uasp.bpm.engine.domain.model.ProcUnit;
import com.huigou.uasp.bpm.engine.domain.model.ProcUnitHandler;
import com.huigou.uasp.bpm.engine.domain.query.ProcunitHandlerQueryRequest;
import com.huigou.uasp.bpm.engine.domain.query.TaskDetail;
import com.huigou.util.SDO;
import org.activiti.engine.*;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 优先注入此类替换huigou包下该类型bean
 */
@Primary
@Service
public class WorkflowApplicationImplOverride  extends WorkflowApplicationImpl {

    @Autowired
    BsnMessageApplication bsnMessageApplication;

    @Override
    public Map<String, Object> queryTrackingTasks() {
        //当前登录用户是否以任务发起人的身份发起过任务
        List<Map<String, Object>> maps = bsnMessageApplication.queryFinishBsnMessage();
        List<BsnMessage> bsnMessages = new ArrayList<>();
        //若有发起过任务且所有的执行人执行完毕，则由系统创建一份审批任务给当前用户
        for (Map<String, Object> map : maps) {
            BsnMessage bsnMessage = new BsnMessage();
            bsnMessage.setTaskSponsor("system");
            bsnMessage.setListners(this.getOperator().getUserId());
//            bsnMessage.setBusinessCode("system");
            bsnMessage.setActive(ActiveStatus.UNFINISHED.getValue());
            bsnMessage.setCreateDate(new Date());
            bsnMessage.setTitle(map.get("title")+"[完成]");
            bsnMessage.setTaskDescribe("请审批");
            bsnMessage.setExecutorUrl((String)map.get("businessId"));
            bsnMessage.setBusinessId((String)map.get("executorUrl"));
            bsnMessages.add(bsnMessage);
        }
        bsnMessageApplication.saveBsnMessage(bsnMessages);
        //获取任务执行人为当前用户的任务
        return this.bsnMessageApplication.queryBsnMessage();
    }

    public WorkflowApplicationImplOverride() {
        super();
    }

    @Override
    public OrgApplication getOrgApplication() {
        return super.getOrgApplication();
    }

    @Override
    public ActApplication getActApplication() {
        return super.getActApplication();
    }

    @Override
    public void setRepositoryService(RepositoryService repositoryService) {
        super.setRepositoryService(repositoryService);
    }

    @Override
    public RepositoryService getRepositoryService() {
        return super.getRepositoryService();
    }

    @Override
    public void setFormService(FormService formService) {
        super.setFormService(formService);
    }

    @Override
    public FormService getFormService() {
        return super.getFormService();
    }

    @Override
    public void setRuntimeService(RuntimeService runtimeService) {
        super.setRuntimeService(runtimeService);
    }

    @Override
    public RuntimeService getRunTimeService() {
        return super.getRunTimeService();
    }

    @Override
    public void setTaskService(TaskService taskService) {
        super.setTaskService(taskService);
    }

    @Override
    public TaskService getTaskService() {
        return super.getTaskService();
    }

    @Override
    public void setManagementService(ManagementService managementService) {
        super.setManagementService(managementService);
    }

    @Override
    public void setHistoryService(HistoryService historyService) {
        super.setHistoryService(historyService);
    }

    @Override
    public HistoryService getHistoryService() {
        return super.getHistoryService();
    }

    @Override
    public ProcUnitHandlerApplication getProcUnitHandlerService() {
        return super.getProcUnitHandlerService();
    }

    @Override
    public void deploy(String procId, String fileName) {
        super.deploy(procId, fileName);
    }

    @Override
    public ProcessInstance startAndAdvanceProcessInstanceByKey(String processDefinitionKey, String businessKey, Map<String, Object> variables) {
        return super.startAndAdvanceProcessInstanceByKey(processDefinitionKey, businessKey, variables);
    }

    @Override
    public ProcessInstance startAndAdvanceProcessInstanceByKeyInNewTransaction(String processDefinitionKey, String businessKey, Map<String, Object> variables) {
        return super.startAndAdvanceProcessInstanceByKeyInNewTransaction(processDefinitionKey, businessKey, variables);
    }

    @Override
    public ProcessInstance startProcessInstanceByKey(String processDefinitionKey, String businessKey, Map<String, Object> variables) {
        return super.startProcessInstanceByKey(processDefinitionKey, businessKey, variables);
    }

    @Override
    public ProcessInstance startProcessInstanceByKey(String processDefinitionKey, Map<String, Object> variables) {
        return super.startProcessInstanceByKey(processDefinitionKey, variables);
    }

    @Override
    public void saveBizData(String bizId, String taskId) {
        super.saveBizData(bizId, taskId);
    }

    @Override
    public Boolean showQueryHandlers(String bizId, String processDefinitionKey, String procUnitId, Integer groupId, String procUnitHandlerId) {
        return super.showQueryHandlers(bizId, processDefinitionKey, procUnitId, groupId, procUnitHandlerId);
    }

    @Override
    public Map<String, Object> queryHandlers(String bizId, String taskId) {
        return super.queryHandlers(bizId, taskId);
    }

    @Override
    public void advance(String taskId, Map<String, Object> variables) {
        super.advance(taskId, variables);
    }

    @Override
    public void batchAdvance(List<BatchAdvanceParameter> batchAdvanceParameters) {
        super.batchAdvance(batchAdvanceParameters);
    }

    @Override
    public void completeTask(String taskId) {
        super.completeTask(taskId);
    }

    @Override
    public void deleteTask(String taskId) {
        super.deleteTask(taskId);
    }

    @Override
    public void updateTaskDescription(String taskId, String description) {
        super.updateTaskDescription(taskId, description);
    }

    @Override
    public void updateTasksDescription(Map<String, Object> params) {
        super.updateTasksDescription(params);
    }

    @Override
    public void completeMendTask(String bizId, String taskId) {
        super.completeMendTask(bizId, taskId);
    }

    @Override
    public void completeReplenishTask(String bizId, String taskId) {
        super.completeReplenishTask(bizId, taskId);
    }

    @Override
    public void abortTask(String taskId) {
        super.abortTask(taskId);
    }

    @Override
    public void abortProcessInstance(String processInstanceId) {
        super.abortProcessInstance(processInstanceId);
    }

    @Override
    public void abortProcessInstanceByBizId(String bizId) {
        super.abortProcessInstanceByBizId(bizId);
    }

    @Override
    public void abortProcessInstanceByBizCode(String bizCode) {
        super.abortProcessInstanceByBizCode(bizCode);
    }

    @Override
    public void suspendTask(String taskId) {
        super.suspendTask(taskId);
    }

    @Override
    public void recoverTask(String taskId) {
        super.recoverTask(taskId);
    }

    @Override
    public void sleep(String taskId) {
        super.sleep(taskId);
    }

    @Override
    public void deleteProcessInstance(String processInstanceId, String deleteReason) {
        super.deleteProcessInstance(processInstanceId, deleteReason);
    }

    @Override
    public void recallProcessInstance(String processInstanceId, String taskId) {
        super.recallProcessInstance(processInstanceId, taskId);
    }

    @Override
    public void back(String taskId, String destActivityId, String backToProcUnitHandlerId) {
        super.back(taskId, destActivityId, backToProcUnitHandlerId);
    }

    @Override
    public void backToApplyActivity(String taskId, String processInstanceId) {
        super.backToApplyActivity(taskId, processInstanceId);
    }

    @Override
    public List<ActivityImpl> queryBackActivity(String taskId) {
        return super.queryBackActivity(taskId);
    }

    @Override
    public void withdrawTask(String taskId, String previousId) {
        super.withdrawTask(taskId, previousId);
    }

    @Override
    public void withdrawTaskByBizId(String taskId, String bizId) {
        super.withdrawTaskByBizId(taskId, bizId);
    }

    @Override
    public void transmit(String catalogId, String taskId, String procUnitHandlerId, String executorId, Integer sendMessage) {
        super.transmit(catalogId, taskId, procUnitHandlerId, executorId, sendMessage);
    }

    @Override
    public void assign(String taskId, String procUnitHandlerId, List<String> personMemberIds) {
        super.assign(taskId, procUnitHandlerId, personMemberIds);
    }

    @Override
    public void claim(String taskId, String personMemberId) {
        super.claim(taskId, personMemberId);
    }

    @Override
    public void makeACopyForEvent(String taskId, List<String> executorIds) {
        super.makeACopyForEvent(taskId, executorIds);
    }

    @Override
    public void makeACopyFor(String taskId, List<String> executorIds) {
        super.makeACopyFor(taskId, executorIds);
    }

    @Override
    public void makeACopyFor(String taskId, List<String> executorIds, String description) {
        super.makeACopyFor(taskId, executorIds, description);
    }

    @Override
    public void createNoticeTask(String procUnitName, String description, List<String> executorIds) {
        super.createNoticeTask(procUnitName, description, executorIds);
    }

    @Override
    public void createNoticeTask(String procUnitName, String description, List<String> executorIds, String formKey, String businessKey) {
        super.createNoticeTask(procUnitName, description, executorIds, formKey, businessKey);
    }

    @Override
    public void doCreateCoordinationTask(CoordinationTask coordinationTask) {
        super.doCreateCoordinationTask(coordinationTask);
    }

    @Override
    public void createCoordinationTask(CoordinationTask coordinationTask) {
        super.createCoordinationTask(coordinationTask);
    }

    @Override
    public List<ProcUnit> getAllProcessDefinitions() {
        return super.getAllProcessDefinitions();
    }

    @Override
    public List<ProcUnit> getUserTaskActivitiesByProcessDefinitionId(String processDefinitionId) {
        return super.getUserTaskActivitiesByProcessDefinitionId(processDefinitionId);
    }

    @Override
    public TaskDetail queryTaskDetail(String taskId) {
        return super.queryTaskDetail(taskId);
    }

    @Override
    public Map<String, Object> queryTasks(SDO params) {
        return super.queryTasks(params);
    }

    @Override
    public List<?> queryFlowChartProcedure(String bizId) {
        return super.queryFlowChartProcedure(bizId);
    }

    @Override
    public Map<String, Object> queryFlowChart(String bizId, String ownerOrgId, String isShowAllRules) {
        return super.queryFlowChart(bizId, ownerOrgId, isShowAllRules);
    }

    @Override
    public Map<String, Object> getProcedureInfo(String bizId, String procUnitHandlerId) {
        return super.getProcedureInfo(bizId, procUnitHandlerId);
    }

    @Override
    public Map<String, Object> queryApprovalHistoryByBizId(String bizId) {
        return super.queryApprovalHistoryByBizId(bizId);
    }

    @Override
    public Map<String, Object> queryBackTasksByBizCode(String bizCode, String procUnitId, Integer groupId) {
        return super.queryBackTasksByBizCode(bizCode, procUnitId, groupId);
    }

    @Override
    public Map<String, Object> queryBackTasksByBizId(String bizId, String procUnitId, Integer groupId) {
        return super.queryBackTasksByBizId(bizId, procUnitId, groupId);
    }

    @Override
    public Map<String, Object> queryBackProcUnit(String procInstId, String approvalRuleId, Integer groupId) {
        return super.queryBackProcUnit(procInstId, approvalRuleId, groupId);
    }

    @Override
    public Map<String, Object> queryCounterSignHandlers(String bizId, String procUnitId) {
        return super.queryCounterSignHandlers(bizId, procUnitId);
    }

    @Override
    public void saveCounterSignHandlers(String bizId, String procUnitId, Long version, String currentProcUnitHandlerId, List<String> minusSignIds, List<ProcUnitHandler> countersigns) {
        super.saveCounterSignHandlers(bizId, procUnitId, version, currentProcUnitHandlerId, minusSignIds, countersigns);
    }

    @Override
    public List<ProcUnitHandler> queryAssistHandlers(String bizId, String procUnitId, String chiefId) {
        return super.queryAssistHandlers(bizId, procUnitId, chiefId);
    }

    @Override
    public void assist(String bizId, String taskId, String procUnitHandlerId, List<String> deletedIds, List<String> executorIds, List<Integer> sendMessages) {
        super.assist(bizId, taskId, procUnitHandlerId, deletedIds, executorIds, sendMessages);
    }

    @Override
    public List<Map<String, Object>> queryUIElmentPermissionsByProcUnitHandlerId(String id) {
        return super.queryUIElmentPermissionsByProcUnitHandlerId(id);
    }

    @Override
    public void updateHistoricTaskInstanceStatus(String taskId, String status) {
        super.updateHistoricTaskInstanceStatus(taskId, status);
    }

    @Override
    public void updateTaskExtensionStatus(String taskId, TaskStatus taskStatus) {
        super.updateTaskExtensionStatus(taskId, taskStatus);
    }

    @Override
    public void launchMendTask(String bizId, String procUnitId) {
        super.launchMendTask(bizId, procUnitId);
    }

    @Override
    public void mend(String bizId, String procUnitId, String currentProcUnitHandlerId, Long version, List<ProcUnitHandler> countersigns) {
        super.mend(bizId, procUnitId, currentProcUnitHandlerId, version, countersigns);
    }

    @Override
    public void replenish(String backToTaskId, String currentTaskId, String procUnitHandlerId) {
        super.replenish(backToTaskId, currentTaskId, procUnitHandlerId);
    }

    @Override
    public String saveComment(String procUnitHandlerId, String bizId, String message) {
        return super.saveComment(procUnitHandlerId, bizId, message);
    }

    @Override
    public List<Comment> queryProcUnitHandlerComments(String procUnitHandlerId) {
        return super.queryProcUnitHandlerComments(procUnitHandlerId);
    }

    @Override
    public List<ActivityImpl> queryProcessInstanceActiveActivities(String procInstId) {
        return super.queryProcessInstanceActiveActivities(procInstId);
    }

    @Override
    public void handTasks(String fromPersonId, String toPsmId) {
        super.handTasks(fromPersonId, toPsmId);
    }

    @Override
    public void collectTask(String taskId) {
        super.collectTask(taskId);
    }

    @Override
    public void cancelCollectionTask(String taskId) {
        super.cancelCollectionTask(taskId);
    }

    @Override
    public Map<String, Object> queryCurrentOperatorTaskStatistics() {
        return super.queryCurrentOperatorTaskStatistics();
    }

    @Override
    public String findBpmnDelegateClassCanonicalName(String taskId) {
        return super.findBpmnDelegateClassCanonicalName(taskId);
    }

    @Override
    public Boolean checkAssistantPassRule(String processDefinitionKey, String taskDefinitionKey, String bizId, String procUnitHandlerId) {
        return super.checkAssistantPassRule(processDefinitionKey, taskDefinitionKey, bizId, procUnitHandlerId);
    }

    @Override
    public Map<String, Object> loadRuntimeTaskByBizId(String bizId) {
        return super.loadRuntimeTaskByBizId(bizId);
    }

    @Override
    public Map<String, Object> slicedQueryProcunitHandler(ProcunitHandlerQueryRequest queryRequest) {
        return super.slicedQueryProcunitHandler(queryRequest);
    }
}
