var gridManager = null;

$(document).ready(function() {
	initializateUI();
	loadProcessListGrid();
});


function initializateUI() {
	UICtrl.layout("#layout", {leftWidth: 3});  
}

function loadProcessListGrid() {
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addHandler: function(){
			addHandler();
		},
		updateHandler: function(){
			updateHandler();
		},
		deleteHandler: deleteHandler,
	});
    gridManager =  UICtrl.grid("#processListGrid", {
        columns: [
                  { display: "topsun.process.processName", name: "processName", width: 200, minWidth: 60, type: "string", align: "left" },
                  { display: "topsun.process.processType", name: "processTypeTextView", width: 200, minWidth: 60, type: "string", align: "left" },
				  { display: "topsun.process.workHours", name: "workHours", width: 100, minWidth: 60, type: "string", align: "left" },
                  { display: "topsun.process.processContent", name: "processContent", width: 300, minWidth: 60, type: "string", align: "left" },
				  { display: "topsun.process.processRemark", name: "processRemark", width: 300, minWidth: 60, type: "string", align: "left" },
                  ],
        dataAction: "server",
     	url: web_app.name + '/process/slicedProcessList.ajax',
     	pageSize: 20,
     	usePager: true,
     	toolbar: toolbarOptions,
     	width: "100%",
     	height: "100%",
     	heightDiff: -8,
     	checkbox: true,
     	fixedCellHeight: true,
     	selectRowButtonOnly: true,
     	onDblClickRow : function(data, rowindex, rowobj) {
			updateHandler(data);
		}
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
	var param = $(obj).formToJSON();
	UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
	gridManager.loadData();
} 

function resetForm(obj) {
	$(obj).formClean();
}

function addHandler(){
	/*UICtrl.showAjaxDialog({
		url: web_app.name + '/process/addProcessDetail.load',
		title: "新增工艺设置",
		width: 800,
		ok: function(div){
			var _self=this;
			$('#submitForm',div).ajaxSubmit({url: web_app.name + '/process/saveProcess.ajax',
				success : function() {
					_self.close();
					reloadGrid();
				}
			});
		}
	});*/
	UICtrl.addTabItem({
		tabid: 'processDetail',
		text: $.i18nProp("topsun.process.add"),
		url: web_app.name + '/process/addProcessDetail.do'
	})
}

function updateHandler(row){
	if (!row) {
		row = DataUtil.getUpdateRow(gridManager);
		if (!row) {
			return;
		}
	}
	/*UICtrl.showAjaxDialog({
		url: web_app.name + '/process/showProcessDetail.load',
		title: "修改工艺设置",
		width: 800,
		param:{processId:row.processId},
		ok: function(div){
			var _self=this;
			$('#submitForm',div).ajaxSubmit({url: web_app.name + '/process/saveProcess.ajax',
				success : function() {
					_self.close();
					reloadGrid();
				}
			});
		}
	});*/
	UICtrl.addTabItem({
		tabid: 'processDetail'+row.processId,
		text: $.i18nProp("topsun.process.update"),
		url: web_app.name + '/process/showProcessDetail.do?processId='+row.processId
	})
}

//删除按钮
function deleteHandler() {
	DataUtil.del({
		action: 'technology/deleteProcessByProcessId.ajax',
		gridManager: gridManager, idFieldName: 'processId',
		onSuccess: function () {
			reloadGrid();
		}
	});
}


