$(document).ready(function() {
    loadSapWorkCenterGrid();
});

function loadSapWorkCenterGrid() {
    let toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function(){
            addHandler();
        },
        updateHandler: function(){
            updateHandler();
        }
    });
    gridManager =  UICtrl.grid("#sapWorkCenterGrid", {
        columns: [
            { display: "填写说明", name: "productName", width: 140, minWidth: 60, type: "string", align: "left"},
            { display: "维护标识", name: "productCategoryId", width: 120, minWidth: 60, type: "string", align: "left" },
            { display: "工厂", name: "werks", width: 120, minWidth: 60, type: "string", align: "left" },
            { display: "工作中心", name: "apbpl", width: 100, minWidth: 60, type: "string", align: "left" },
            { display: "工作中心描述", name: "stext", width: 150, minWidth: 60, type: "string", align: "left" },
            { display: "工作中心类别", name: "verwe", width: 100, minWidth: 60, type: "string", align: "left" },
            { display: "工作中心负责人", name: "veran", width: 140, minWidth: 60, type: "string", align: "left" },
            { display: "用途a", name: "a", width: 140, minWidth: 60, type: "string", align: "left" },
            { display: "反冲", name: "rgekz", width: 140, minWidth: 60, type: "string", align: "left" },
            { display: "标准值码", name: "vorgschl", width: 140, minWidth: 60, type: "string", align: "left" },
            { display: "控制码", name: "steus", width: 140, minWidth: 60, type: "string", align: "left" },
            { display: "成本控制范围b", name: "b", width: 140, minWidth: 60, type: "string", align: "left" },
            { display: "成本中心", name: "kostl", width: 140, minWidth: 60, type: "string", align: "left" },
            { display: "成本中心描述c", name: "c", width: 140, minWidth: 60, type: "string", align: "left" },
            { display: "定员d", name: "d", width: 140, minWidth: 60, type: "string", align: "left" },
            { display: "生产速度e", name: "e", width: 140, minWidth: 60, type: "string", align: "left" },
            { display: "速度单位f", name: "f", width: 140, minWidth: 60, type: "string", align: "left" },
        ],
        dataType: "server",
        url: web_app.name + '/sapWorkCenter/findWorkCenter.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "80%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow : function(data, rowindex, rowobj) {
            updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function updateHandler(data) {
    let id = data.id;
    if (!id) {
        id = DataUtil.getUpdateRowId(gridManager);
        if (!id) {
            return;
        }
    }
    let url = DataUtil.composeURLByParam('/sapWorkCenter/goWorkCenterDetail.do', data);
    UICtrl.addTabItem({tabid: 'workCenterEdit' + new Date().getTime(), text: "AAAA", url: url});
}