var gridManager = null;

$(document).ready(function () {
    initializateUI();
    loadSalesOrderListGrid();
});

function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadSalesOrderListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addHandler();
        },
        updateHandler: function () {
            updateHandler();
        },
        deleteHandler: deleteHandler,
    });
    gridManager = UICtrl.grid("#salesOrderListGrid", {
        columns: [
            {display: "销售单号", name: "salesOrderCode", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "订单类型", name: "salesOrderType", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "客户", name: "salesOrderCustomer", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "客户单号", name: "salesOrderCustomerCode", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "下单日期", name: "salesOrderDate", width: 160, minWidth: 60, type: "string", align: "left"},
            {display: "交易币别", name: "salesOrderCurrency", width: 120, minWidth: 60, type: "datetime", align: "left"},
            {display: "交易倍数", name: "salesOrderMultiple", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "款式", name: "salesOrderStyle", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申购/采购单号", name: "salesOrderProcureCode", width: 160, minWidth: 60, type: "string", align: "left"},
            {display: "跟单员", name: "salesOrderMerchandiser", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "备注", name: "salesOrderRemarks", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "创建时间", name: "salesOrderCreateTime", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "创建人", name: "salesOrderCreator", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "审批时间", name: "salesOrderApprovalTime", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "审核人", name: "salesOrderReviewer", width: 120, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/customer/findCustomer.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

//增加按钮
function addHandler() {
    UICtrl.addTabItem({
        tabid: 'addCustomerDetail',
        text: '添加客户详细信息',
        url: web_app.name + '/customer/addCustomerDetail.do'
    })
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'customer/deleteCustomerAndAffiliatedInfoByCustomerId.ajax',
        gridManager: gridManager, idFieldName: 'customerId',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

//修改按钮
function updateHandler(data) {
    if (!data) {
        data = DataUtil.getUpdateRow(gridManager);
        if(!data) {
            return;
        }
    }
    UICtrl.addTabItem({
        tabid: 'customerDetail' + data.customerId,
        text: '客户详细信息',
        url: web_app.name + '/customer/forwardCustomerDetail.do?customerId=' + data.customerId
    })
}



