var purchaseApprovalGridManager = null;
$(document).ready(function () {
        initUI();
        initPurchaseListGrid();
    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function initPurchaseListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
    });
    purchaseApprovalGridManager = UICtrl.grid('#purchaseApprovalGrid', {
            columns: [
                {display: "状态", name: "statusTextView", width: "100", align: "left", type: "string"}
                , {display: "id", name: "id", width: "140", align: "left", type: "string", hide: true}
                , {display: "需求跟踪编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "采购申请类型描述", name: "batxt", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "采购申请编号", name: "banfn", width: 150, minWidth: 60, type: "string", align: "center"}
            ],
            dataAction: 'server',
            url: web_app.name + '/sapPurchaseApproval/slicedSapPurchaseApprovalList.ajax?',
            //parms: {requireItemId: $("#prepareItemId").val()},
            toolbar: toolbarOptions,
            width: '99.8%',
            height: '100%',
            pageSize: 100,
            heightDiff: -4,
            //sortName: 'lastModifiedDate',
            //sortOrder: 'desc',
            checkbox: true,
            usePager: true,
            rownumbers: true,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
            onSuccess: function (data) {
                if (data.error) {
                    Public.tip(data.error);
                }
            }
            ,
            onDblClickRow: function (data, rowindex, rowobj) {
                viewHandler(data.id);
            },
            onAfterShowData: function (currentData) {

            }
        }
    );
    UICtrl.setSearchAreaToggle(purchaseApprovalGridManager);
}


/**
 * 查看采购申请详情
 * @param id 采购申请id
 * @returns {boolean}
 */
function viewHandler(id) {
    if (!id) {
        var row = DataUtil.getSelectedRow(purchaseApprovalGridManager);
        if (!row) {
            return row;
        }
        id = row.id;
    }
    UICtrl.addTabItem({
        tabid: 'viewPurchase' + id,
        text: '查看采购申请',
        url: web_app.name + '/sapPurchaseApproval/showSapPurchaseApprovalDetail.job?bizId=' + id
    });
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'addPurchase',
        text: '新增采购审批',
        url: web_app.name + '/sapPurchaseApproval/forwardSapPurchaseApprovalDetail.job'
    });
}


function reloadPurchaseGrid() {
    var params = $("#queryMainForm").formToJSON();
    UICtrl.gridSearch(purchaseApprovalGridManager, params);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(purchaseApprovalGridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
}

