var purchaseGridManager = null, refreshFlag = false, _roleId = null, purchaseSelectedList = [];
$(document).ready(function () {
        initUI();
        initPurchaseListGrid();

    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function initPurchaseListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
    });
    purchaseGridManager = UICtrl.grid('#purchaseGrid', {
            columns: [
                {display: "状态", name: "statusTextView", width: "100", align: "left", type: "string"}
                , {display: "id", name: "id", width: "140", align: "left", type: "string", hide: true}
                , {display: "需求跟踪编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "PR类型", name: "bsartTextView", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "采购申请编号", name: "banfn", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "批准时间", name: "frgdt", width: 200, minWidth: 60, type: "date", align: "center"}
            ],
            dataAction: 'server',
            url: web_app.name + '/sapPurchase/slicedSapPurchaseList.ajax?',
            //parms: {requireItemId: $("#prepareItemId").val()},
            toolbar: toolbarOptions,
            width: '99.8%',
            height: '100%',
            pageSize: 100,
            heightDiff: -4,
            //sortName: 'lastModifiedDate',
            //sortOrder: 'desc',
            checkbox: true,
            usePager: true,
            rownumbers: true,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
            onSuccess: function (data) {
                if (data.error) {
                    Public.tip(data.error);
                }
            }
            ,
            onDblClickRow: function (data, rowindex, rowobj) {
                viewHandler(data.parentId);
            },
            onAfterShowData: function (currentData) {

            }
        }
    );
    UICtrl.setSearchAreaToggle(purchaseGridManager);
}


/**
 * 查看采购申请详情
 * @param parentId 采购申请id
 * @returns {boolean}
 */
function viewHandler(parentId) {
    if (!parentId) {
        var row = DataUtil.getSelectedRow(purchaseGridManager);
        if (!row) {
            return row;
        }
        parentId = row.parentId;
    }
    UICtrl.addTabItem({
        tabid: 'viewPurchase' + parentId,
        text: '查看采购申请',
        url: web_app.name + '/purchase/loadPurchaseDetail.do?isReadOnly=true&id=' + parentId
    });
}

function updateHandler() {
    var row = DataUtil.getSelectedRow(purchaseGridManager);
    if (!row) {
        return;
    }
    UICtrl.addTabItem({
        tabid: 'updatePurchase' + row.parentId,
        text: '修改采购申请',
        url: web_app.name + '/purchase/loadPurchaseDetail.do?id=' + row.parentId
    });

}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'addPurchase',
        text: '新增采购申请',
        url: web_app.name + '/sapPurchase/forwardSapPurchaseDetail.job'
    });
}

function deleteHandler() {
    var rows = DataUtil.getObjectBagData("purchaseGrid");
    if (!rows || rows.length < 1) {
        Public.tip('common.warning.nochoose');
        return;
    }
    var ids = [];
    for (var i = 0; i < rows.length; i++) {
        var row = rows[i];
        if (row.status != 0) {
            Public.errorTip('只能删除草稿状态的数据!');
            return;
        }
        ids.push(row.id);
    }
    if (!ids) {
        return;
    }
    Public.ajax(web_app.name + '/purchaseItem/deleteByIds.ajax',
        {ids: $.toJSON(ids)},
        function () {
            reloadPurchaseGrid();
        });
}

function reloadPurchaseGrid() {
    var params = $("#queryMainForm").formToJSON();
    UICtrl.gridSearch(purchaseGridManager, params);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(purchaseGridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
}

