var gridManager = null;

$(document).ready(function () {

    initializateUI();
    loadGrid();
})
function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadGrid() {

    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function (){
            addHandler()
        },
        deleteHandler: deleteHandler,
    });
    gridManager = UICtrl.grid("#costReimbursementListGrid", {
        columns: [
            {display: "EP付款申请类别", name: "zepFtype", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "EP付款申请类别名称", name: "zepFtypename", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "公司代码", name: "bukrs", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "公司代码名称", name: "butxt", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "EP部门代码", name: "zepDepart", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "EP部门名称", name: "zepDepartname", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "EP流程申请人代码", name: "zepAppli", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "EP流程申请人", name: "zepAppliname", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "付款申请创建日期", name: "zepFcrdate", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "EP流程单号", name: "zepNo", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "付款申请内容", name: "zepTxt", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "填报日期", name: "fillinDate", width: 140, minWidth: 60, type: "string", align: "left"},

        ],
        dataAction: "server",
        url: web_app.name + '/sapCostReimbursement/slicedSapCostReimbursementList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        }

    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}


//重写DataUtil的getUpdateRowId函数、它默认取行的id列
DataUtil.getUpdateRowId = function (gridManager) {
    var result = DataUtil.getUpdateRow(gridManager);
    if (result) {
        return result.proofingMakeId;
    }
    return result;
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'sapCostReimbursement/deleteStatsIndicators.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'costReimbursement',
        text: "费用报销申请单",
        url: web_app.name + '/sapCostReimbursement/forwardCostReimbursement.job'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'showCostReimbursement'+id,
        text: "费用报销详情",
        url: web_app.name + '/sapCostReimbursement/showSapCostReimbursement.do?bizId='+id+"&isDetailPage=true"
    });
}

// function sendSapData(bizId){
//     Public.ajax(web_app.name + '/sapStatsIndicators/againSendSapDate.ajax',{bizId:bizId},function (data){
//         reloadGrid();
//     })
// }