var tableArray = [
    {
        parms: {},
        node: "reimbursementApplierGrid",
        gridManager: null,
        data: null,
        columns: [
            {display: "EP流程子序号", name: "zepItemno", width: 80, minwidth: 80, type: "string", align: "left"},
            {
                display: "计划内外付款标识", name: "zepPlan", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "计划内外标识名称",
                name: "zepPlanname",
                width: 120,
                minwidth: 120,
                type: "string",
                align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "BP标识", name: "zepBptype", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "BP标识描述", name: "zepBptypename", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "BP", name: "partner", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "BP账号名称", name: "koinh", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "BP联行号", name: "bankl", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "BP银行账号", name: "bankn", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "SWIFT/BIC", name: "swift", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "费用类型代码", name: "zepExtype", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "费用类型名称",
                name: "zepExtypename",
                width: 120,
                minwidth: 120,
                type: "string",
                align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "费用会计科目", name: "hkont", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "总账科目描述", name: "txt50", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "计划付款日期", name: "zepFpldate", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "成本中心", name: "kostl", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "成本中心名称", name: "ktext1", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "内部订单", name: "aufnr", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "内部订单描述", name: "ktext", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "币别", name: "waers", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "汇率", name: "kursf", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "不含税金额", name: "netwr", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "税额", name: "kwetr", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "含税金额", name: "kzwi1", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "税码", name: "mwskz", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "不含税金额（本位币）", name: "netwr1", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "税额（本位币）", name: "kwetr1", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "含税金额（本位币）", name: "kzwi11", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
        ]
    }, {
        parms: {},
        node: "financialAuditGrid",
        gridManager: null,
        data: null,
        columns: [
            {display: "EP流程子序号", name: "zepItemno", width: 80, minwidth: 80, type: "string", align: "left"},
            {
                display: "原因代码", name: "rstgr", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "不含税金额（审批）",
                name: "zepPdamount1",
                width: 120,
                minwidth: 120,
                type: "string",
                align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "税额（审批）", name: "zepPdtax1", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "含税金额（审批）",
                name: "zepPtdamount1",
                width: 120,
                minwidth: 120,
                type: "string",
                align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "不含税金额（审批-本位币）",
                name: "zepPdamount",
                width: 120,
                minwidth: 120,
                type: "string",
                align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "税额（审批-本位币）",
                name: "zepPdtax",
                width: 120,
                minwidth: 120,
                type: "string",
                align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "含税金额（审批-本位币）",
                name: "zepPtdamount",
                width: 120,
                minwidth: 120,
                type: "string",
                align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "付款方式代码", name: "zlsch", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "付款方式名称", name: "zlschText1", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "直联付款标识", name: "zepBank", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
        ]
    }
    , {
        parms: {},
        node: "capitalPostGrid",
        gridManager: null,
        data: null,
        columns: [
            {display: "EP流程子序号", name: "zepItemno", width: 80, minwidth: 80, type: "string", align: "left"},
            {
                display: "付款银行账号", name: "bankn1", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "付款银行账号名称",
                name: "zt012kText1",
                width: 120,
                minwidth: 120,
                type: "string",
                align: "left",
                editor: {

                    type: 'text'
                }
            },
            {
                display: "付款附言", name: "zepTxt1", width: 120, minwidth: 120, type: "string", align: "left",
                editor: {

                    type: 'text'
                }
            },
        ]
    }
]


//创建表格（参数、列、插入的节点、数据源）
function loadGrid(obj) {
    var toolbarOptions =null;
    // if(obj.node=="reimbursementApplierGrid") {
        toolbarOptions= UICtrl.getDefaultToolbarOptions({
            addHandler: function () {
                tableArray.forEach((item) => {
                    UICtrl.addGridRow(item.gridManager, {zepItemno: getZepItemNo()});
                });
            },
            deleteHandler: function () {
                tableArray.forEach((item) => {
                    item.gridManager.deleteSelectedRow();
                });
            }
        });
    // }
    obj.gridManager = UICtrl.grid("#" + obj.node, {
        columns: obj.columns,
        dataAction: "local",
        data: obj.data,
        parms: obj.parms,
        pageSize: 20,
        toolbar: toolbarOptions,
        usePager: false,
        enabledEdit: true,
        // width: "100%",
        // height: 300,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onBeforeCheckRow: function (checked, data) {
            //同时选定所有表格中的对应列
            tableArray.forEach((item) => {
                let rows = item.gridManager.rows;
                let row = {};
                rows.forEach((temp) => {
                    if (temp.zepItemno === data.zepItemno) {
                        row = temp;
                    }
                })
                item.gridManager.select(row);
            })
        }
    });
    UICtrl.setSearchAreaToggle(obj.gridManager);

}


$(document).ready(function () {
    initialize();
});


function initialize() {
    //获取数据源初始化表格
    Public.ajax(web_app.name + '/sapCostReimbursement/slicedSapCostReimbursementDetailList.ajax', {id: getId()}, function (data) {
        //根据定义列拆除实体对象，封装成每个table对应的数据集
        tableArray.forEach(obj => {
            obj.data = {
                Rows: data.map(item => {
                    let row = {};
                    obj.columns.forEach(col => {
                        if (item.hasOwnProperty(col.name)) {
                            row[col.name] = item[col.name];
                        }
                    });
                    return row;
                })
            };
        });
        useArrayTable(loadGrid);
    })
}


/**
 * 流程引擎回调设置打样的id
 * @param value 打样申请的id
 */
function setId(id) {
    $("#id").val(id);
}

/**
 * 流程引擎获取打样申请id的回掉方法。
 * @return 打样申请的id
 */
function getId() {
    return $("#id").val() || "";
}

function getExtendedData(processAction) {
    tableArray.forEach((item) => {
        console.log(item)
    });
    debugger

    //回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
        //不验证
        $('#submitForm').attr('check', false);
    }
    let resultArray = useArrayTable(getTableDateAll);

    //根据zepItemno将各列表属性合并为一个完整实体
    const result = resultArray[0].map((obj1) => {
        const mergedObj = {...obj1};
        for (let i = 1; i < resultArray.length; i++) {
            const currentArr = resultArray[i];
            const currentObj = currentArr.find((obj) => obj.zepItemno === obj1.zepItemno);
            if (currentObj) {
                Object.assign(mergedObj, currentObj);
            }
        }
        return mergedObj;
    });

    let extendedData = {};
    extendedData.CRDetail = Public.encodeJSONURI(result);
    return extendedData;

}

function getTableDateAll(obj) {
    let result = DataUtil.getGridData({
        gridManager: obj.gridManager,
        isAllData: true
    });
    return result;
}

//调用数组
function useArrayTable(func, ...data) {
    const results = tableArray.map((item) => {
        return func(item, ...data);
    });
    return results;
}

//获取序号当前值
function getZepItemNo(){
    debugger
    let result =getTableDateAll(tableArray[tableArray.length-1]);
    let zepItemNo="001";
    if(result.length>0){
        //获取上一个节点的子序值
        let wornNo= parseInt(result[result.length-1]["zepItemno"], 10);
        zepItemNo=("00" + (wornNo + 1)).slice(-3);
    }
    return zepItemNo;
}