var gridManager = null;

$(document).ready(function () {
    initializateUI();
    loadCostCenterListGrid();
});


function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadCostCenterListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addHandler();
        },
        updateHandler: function () {
            updateHandler();
        },
        deleteHandler: deleteHandler,
        disableHandler: disableHandler,
    });
    gridManager = UICtrl.grid("#sapCostCenterListGrid", {
        columns: [
            {display: "成本中心编码", name: "kostl", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "名称", name: "ktext", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "描述", name: "ltext", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "成本中心类型", name: "kosarTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "有限期自", name: "datab", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "有限截止日", name: "datbi", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "负责人", name: "verak", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "利润中心", name: "prctrTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "申请人", name: "personMemberName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "联系方式", name: "telePhone", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "申请日期", name: "fillinDate", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "原因", name: "reason", width: 140, minWidth: 60, type: "string", align: "left"},
            {
                display: "状态", name: "isDelete", width: 60, minWidth: 60, type: "string", align: "center",
                render: function (item) {
                    return UICtrl.getStatusInfo(item.isDelete);
                }
            },
            {display: "消息类型", name: "typeTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "消息编号", name: "NUMBER", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "消息文本", name: "MESSAGE", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "应用程序日志", name: "LOG_NO", width: 140, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/sapCostCenter/slicedCostCenterList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        // 双击执行
        onDblClickRow: function (data, rowindex, rowobj) {
            updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'sapCostCenterDetail',
        text: "新增成本中心",
        url: web_app.name + '/sapCostCenter/addCostCenterDetail.job'
    })
}

function updateHandler(row) {
    if (!row) {
        row = DataUtil.getUpdateRow(gridManager);
        if (!row) {
            return;
        }
    }
    UICtrl.addTabItem({
        tabid: 'CostCenterDetail',
        text: "修改成本中心",
        url: web_app.name + '/sapCostCenter/showCostCenterDetail.do?id=' + row.id
    })
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'sapCostCenter/deleteCostCenterById.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

// 冻结按钮
function disableHandler() {
    DataUtil.updateById({
        action: 'sapCostCenter/updateCostCenterStatus.ajax',
        gridManager: gridManager, idFieldName: 'id', param: {status: 0},
        message: 'common.confirm.disable',
        onSuccess: function () {
            reloadGrid();
        }
    });
}
