$(document).ready(function () {
    $("#proofingMakeDetail").fileList();
    bindQueryEvent();
    initialize();
});


function initialize() {
    $("#proofingApplyNgReReason").prop("placeholder","录入此列本单作废");
    /**
     * 如果是详情页，展示数据，隐藏按钮
     * @type {boolean}
     */
    let isDetailPage = ($("#isDetailPage").val() === "true");
    if (isDetailPage) {
        showTechnologyTable({proofingMakeId:$("#proofingMakeId").val()},"proofingMakeTechnologyId",null);
        showBomTable({proofingMakeId:$("#proofingMakeId").val()},"proofingMakeId");
       $("#jobPageTop").hide();
        if($("#jobPageTop").length>0){
            $("#formButton").hide();
        }
    }
}

//绑定selectC
function bindQueryEvent() {
    $('#proofingApplyNo').searchbox({
        type: "proofing", name: "proofingApplyCode",
        onChange: function (value, data) {
            $('#productCode').val(data.productCode);
            ajaxRenderDataGoForm(data.proofingApplyNo);
            showTechnologyTable({proofingApplyId:data.proofingApplyId},"proofingApplyTechnologyId",null);
            showBomTable({proofingApplyId:data.proofingApplyId},"proofingApplyId");
        }
    });
}

/**
 * 表单提交
 * @returns {boolean}
 */
function saveForm() {

   let extendedData= getTableResult();

   if(!extendedData) return false;

    var _self = this;
    $('#submitForm').ajaxSubmit({
        url: web_app.name + '/proofingMake/saveProofingMake.ajax',
        param: extendedData,
        success: function (data) {
            $("#proofingMakeId").val(data.proofingMakeId)
            $("#proofingMakeLookedId").val(data.proofingMakeLookedId)
            $("#proofingMakePdPublishedConfId").val(data.proofingMakePdPublishedConfId)
            Public.successTip("保存成功！");
            _self.close();
        }
    });
}


function resetForm(obj) {
    $(obj).formClean();
}

/**
 * 根据请求获取的数据填充到页面
 * @param proofingApplyNo
 */
function ajaxRenderDataGoForm(proofingApplyNo) {
    Public.ajax(web_app.name + '/proofingMake/queryProofingApply.ajax', {proofingApplyNo: proofingApplyNo}, function (data) {
        //替换前缀为proofingApply的字段为proofingMake
        const updatedData = Object.entries(data).reduce((acc, [key, value]) => {
            const updatedKey = (
                key !== "proofingApplyId" &&
                key !== "proofingApplyNo" &&
                key !== "proofingApplyApplicationStatus")
                ? key.replace("proofingApply", "proofingMake")
                : key;
            acc[updatedKey] = value;
            return acc;
        }, {});
        $('#submitForm').formSet(updatedData);
        //填充select框
        renderingDictionaries(updatedData);
    })
}


/**
 * 渲染带数据字典的select
 * @param obj
 */
function renderingDictionaries(obj) {
    console.log(obj)
    //获取所有select的id名与对象匹配
    $("select").each(function () {
        var id = $(this).attr("id");
        if (obj.hasOwnProperty(id)) {

            var keyValuePairs = new Map();

            $('#' + id + ' option').each(function () {
                var value = $(this).val();
                var text = $(this).text();
                keyValuePairs.set(value, text);
            });

            // 获取 对应的文本值
            var selectedValue = obj[id];
            var selectedText = keyValuePairs.get(selectedValue);

            // 将文本值赋值给目标元素
            $('#' + id + '_text').val(selectedText);
            $('#' + id).val(selectedValue);

            console.log("select:" + id+"("+selectedText+":"+selectedValue+")")
        }
    });
}
