var frontFaceColorGridManager = null,backFaceColorGridManager = null,processGridManager = null,lossGridManager = null,productMaterialGridManager=null;
$(document).ready(function() {
    //loadData();
    initializeUI();
    initializeToolbarContainer();
    initializeTab();
    initFrontFaceColorGrid();
    initBackFaceColorGrid();
    initProcessedGrid();
    initProductLossGrid();
    initProductMaterialGrid();
    bindEvent();
});

function initializeTab() {
    $('#pageTab').tab({
        onClick:function(item){
            var _id=item.data('id');
            var gm=UICtrl.getGridManager('#'+_id);
            UICtrl.onGridResize(gm);
        }
    });
}

function bindEvent() {
    $('#productCategoryName').searchbox({
        type: "product",
        name: "productCode2",
        onChange: function (value, data) {
            $('#productCategoryName').val(data.productCategoryName)
        }
    });

    $('#factoryName').searchbox({
        type: "product",
        name: "productFactoryName",
        onChange: function (value, data) {
            $('#factoryName').val(data.factoryName)
        }
    });

    $('#productTechnologyName').searchbox({
        type: "technology",
        name: "technology",
        onChange: function (value, data) {
            $('#productTechnologyName').val(data.technologyName)
            $('#technologyId').val(data.technologyId)

            var params = {technologyId:data.technologyId};
            $('#processedGrid').ligerGetGridManager().options.url =web_app.name + '/technologyProcess/slicedProcessForProduct.ajax?technologyId='+data.technologyId;
            var _grid = UICtrl.getGridManager('#processedGrid');
            UICtrl.gridSearch(_grid);
        }
    });
}
function initializeUI() {
    UICtrl.layout("#layout",{
        heigth:'280px',
        leftWidth:6,
        rightWidth:6,
        allowRightCollapse: false,
        allowRightResize: false
    });
}

function deleteHandler(){
    DataUtil.del({
        gridManager:gridManager,idFieldName:'id',
        onSuccess:function(){
        }
    });
}

function save() {
    var productAll = $('#submitForm').formToJSON({ check: true });
    if (!productAll) {
        return false;
    }
    var frontFaceColorList = [];
    var backFaceColorList = [];
    var processList = [];
    var lossList = [];
    var productMaterialList = [];
    frontFaceColorList = DataUtil.getGridData({gridManager: frontFaceColorGridManager, isAllData: true, onCheck: true})
    if (!frontFaceColorList) {
        return false;
    }
    productAll.frontFaceColorList = $.toJSON(frontFaceColorList);

    backFaceColorList = DataUtil.getGridData({gridManager: backFaceColorGridManager, isAllData: true, onCheck: true})
    if (!backFaceColorList) {
        return false;
    }
    productAll.backFaceColorList = $.toJSON(backFaceColorList);

    processList = DataUtil.getGridData({gridManager: processGridManager, isAllData: true, onCheck: true})
    if (!processList) {
        return false;
    }
    productAll.processList = $.toJSON(processList);

    lossList = DataUtil.getGridData({gridManager: lossGridManager, isAllData: true, onCheck: true})
    if (!lossList) {
        return false;
    }
    productAll.lossList = $.toJSON(lossList);

    productMaterialList = DataUtil.getGridData({gridManager: productMaterialGridManager, isAllData: true, onCheck: true})
    if (!productMaterialList) {
        return false;
    }
    productAll.productMaterialList = $.toJSON(productMaterialList);

    Public.ajax(web_app.name + "/product/saveProduct.ajax",productAll
    , function (data) {
        $("#productId").val(data.productId);
        $("#productTechnologyId").val(data.productTechnologyId);
        Public.successTip("common.tip.success");
        frontFaceColorGridManager.setParm('productId', data.productId,"face","front");
        frontFaceColorGridManager.loadData();

        backFaceColorGridManager.setParm('productId', data.productId,"face","back");
        backFaceColorGridManager.loadData();

        /*processGridManager.setParm('productTechnologyId', data.productTechnologyId);
        processGridManager.loadData();*/
        $('#processedGrid').ligerGetGridManager().options.url =web_app.name + '/product/slicedProductProcessList.ajax?productTechnologyId='+data.productTechnologyId;
        var _grid = UICtrl.getGridManager('#processedGrid');
        UICtrl.gridSearch(_grid);

        lossGridManager.setParm('productId', data.productId);
        lossGridManager.loadData();

        productMaterialGridManager.setParm('productId', data.productId);
        productMaterialGridManager.loadData();
    });
}

function initializeToolbarContainer(){
    var toolBarOptions= {
        dropup: $('#toolBar').data('dropup') === true,//显示更多按钮时 是否向上打开菜单
        items: [{
            id: 'save',
            remark: '保存',
            name: 'common.button.save',
            icon: 'fa-save',
            delay: true,
            relation: 'advance',
            event: save
        }]
    };
    $('#toolBar').toolBar(toolBarOptions);
    //dropup==true 更多按钮向上展示
    $('#toolBar').data('dropup',true).removeClass('job-button-fixed-top').addClass('job-button-fixed-bottom');
}

function initFrontFaceColorGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function(){
            UICtrl.addGridRow(frontFaceColorGridManager,{ sortOrder: frontFaceColorGridManager.getData().length + 1 ,face:"front"});
        },
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#frontColorsGrid');
            DataUtil.delSelectedRows({
                action: 'product/deleteFaceColor.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'productFaceId',
                onSuccess: function () {
                    frontFaceColorGridManager.loadData();
                    //reloadProcessMaterialGrid();
                }
            });
        },
    });
    frontFaceColorGridManager =  UICtrl.grid("#frontColorsGrid",{
        columns: [
            { display: "颜色名称", name: "colorName", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false, type: "select",
                    data: {
                        type: 'system',
                        name: "queryColor",
                        back: {
                            colorId: "colorId",
                            colorName:"colorName",
                        }
                    },
                }
            },
            { display: "油墨覆盖率(%)", name: "coverageRate", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text'} },
            { display: "排序号", name: "sortOrder", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text'} }
        ],
        dataAction: "server",
        url: web_app.name + '/product/slicedFrontColorList.ajax',
        parms:{productId:$("#productId").val(),face:"front"},
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "100%",
        height: "300",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow : function(data, rowindex, rowobj) {
            //updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(frontFaceColorGridManager);
}

function initBackFaceColorGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function(){
            UICtrl.addGridRow(backFaceColorGridManager,{ sortOrder: backFaceColorGridManager.getData().length + 1 ,face:"back"});
        },
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#backColorsGrid');
            DataUtil.delSelectedRows({
                action: 'product/deleteFaceColor.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'productFaceId',
                onSuccess: function () {
                    backFaceColorGridManager.loadData();
                }
            });
        },
    });
    backFaceColorGridManager =  UICtrl.grid("#backColorsGrid", {
        columns: [
            { display: "颜色名称", name: "colorName", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false, type: "select",
                    data: {
                        type: 'system',
                        name: "queryColor",
                        back: {
                            colorId: "colorId",
                            colorName:"colorName",
                        }
                    },
                }
            },
            { display: "油墨覆盖率(%)", name: "coverageRate", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text'} },
            { display: "排序号", name: "sortOrder", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text'} }
        ],
        dataAction: "server",
        url: web_app.name + '/product/slicedFrontColorList.ajax',
        parms:{productId:$("#productId").val(),face:"back"},
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "100%",
        height: "300",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow : function(data, rowindex, rowobj) {
            //updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(backFaceColorGridManager);
}

function initProcessedGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
    });
    processGridManager =  UICtrl.grid("#processedGrid", {
        columns: [
            { display: "生成顺序", name: "productionSequence", width: 140, minWidth: 60, type: "string", align: "left", editor: { type: 'text' }},
            { display: "工序名称", name: "processName", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text' } },
            { display: "是否排期工序", name: "isScheduleProcess", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: 'dictionary',
                    data: {
                        name: 'yesorno'
                    },
                    textField: 'isScheduleProcessTextView',
                    valueField: 'isScheduleProcess',
                    required: false
                },
            },
            { display: "是否完成工序", name: "isFinishedProcess", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: 'dictionary',
                    data: {
                        name: 'yesorno'
                    },
                    textField: 'isFinishedProcessTextView',
                    valueField: 'isFinishedProcess',
                    required: false
                },
            },
            { display: "工艺备注", name: "processRemark", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text' } },
            { display: "完成时间", name: "finishedTime", width: 120, minWidth: 60, type: "string", align: "left",
                editor: { type: 'date' }
            },
            { display: "签字", name: "signed", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text' } },
        ],
        dataAction: "server",
        url: web_app.name + '/product/slicedProductProcessList.ajax',
        parms:{productTechnologyId:$("#productTechnologyId").val()},
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "100%",
        height: "300",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow : function(data, rowindex, rowobj) {
            //updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(processGridManager);
}

function initProductLossGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function(rawData){
            UICtrl.addGridRow(lossGridManager);
        },
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#productLossGrid');
            DataUtil.delSelectedRows({
                action: 'product/deleteProductLoss.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'productLossId',
                onSuccess: function () {
                    lossGridManager.loadData();
                }
            });
        },
    });
    lossGridManager =   UICtrl.grid("#productLossGrid",{
        columns: [
            { display: "客户名称", name: "customerName", width: 140, minWidth: 60, type: "string", align: "left", editor: { type: 'text', required: false }},
            { display: "产品最大loss数量", name: "productLossMax", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "loss比率", name: "productLossRate", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "备注信息", name: "productLossRedundance", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "产品最大loss数量", name: "productLossRemark", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } }
        ],
        dataAction: "server",
        url: web_app.name + '/product/slicedProductLossList.ajax',
        parms:{productId:$("#productId").val()},
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "100%",
        height: "300",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow : function(data, rowindex, rowobj) {
            //updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(lossGridManager);
}

function initProductMaterialGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function(rawData){
            UICtrl.addGridRow(productMaterialGridManager);
        },
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#productMaterialGrid');
            DataUtil.delSelectedRows({
                action: 'product/deleteProductMaterial.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'productMaterialId',
                onSuccess: function () {
                    productMaterialGridManager.loadData();
                }
            });
        },
    });
    productMaterialGridManager =   UICtrl.grid("#productMaterialGrid",{
        columns: [
            { display: "物料名称", name: "materialName", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "sapMaterialSelect",
                        back: {
                            materialId: "materialId",
                            materialName:"materialName",
                            materialCode:"materialCode",
                            materialUnit:"materialUnit",
                            materialJson:"materialJson",
                        }
                    },
                }
            },
            { display: "物料编码", name: "materialCode", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "物料数量", name: "materialNumber", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "计量单位", name: "materialUnit", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "报废百分比", name: "AUSCH", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "BOM项目文本", name: "POTX1", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "物料清单文本", name: "materialJson", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "BOM版本", name: "bomVersion", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "产品BOM类型", name: "bomType", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "替代组", name: "ALPGR", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "替代优先级", name: "ALPRF", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "策略", name: "ALPST", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "使用概率", name: "EWAHR", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "物料项次", name: "ITEM_NUMBRE", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "物料类别", name: "CATEGORY", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "采购", name: "PROCURE", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } },
            { display: "备注", name: "NOTE", width: 120, minWidth: 60, type: "string", align: "left", editor: { type: 'text',  required: false } }
        ],
        dataAction: "server",
        url: web_app.name + '/product/slicedProductMaterialList.ajax',
        parms:{productId:$("#productId").val()},
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "100%",
        height: "300",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow : function(data, rowindex, rowobj) {
            //updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(productMaterialGridManager);
}