var gridManager = null;

$(document).ready(function () {
    initializateUI();
    loadCodeRuleListGrid();
});

function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 50});
}

function loadCodeRuleListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addHandler();
        },
        updateHandler: function () {
            updateHandler();
        },
        disableHandler: disableHandler,
        enableHandler: enableHandler,
        // 转变为正式产品
        changeHandler: {
            id: 'ConversionToOfficialProducts', text: '转为正式产品', img: 'fa-modx', className: 'btn-gray',
            click: function () {
                var rows = gridManager.getSelectedRows();
                var ids = [];

                rows.forEach(row=>{
                    ids.push(row.productId);
                })
                var url = web_app.name + '/product/ConversionToOfficialProducts.ajax';
                Public.ajax(url, {ids:$.toJSON(ids)}, function () {
                    reloadGrid();
                });
            }
        }
    });
    gridManager = UICtrl.grid("#productListGrid", {
        columns: [
            {display: "产品名称", name: "productName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "产品类别", name: "productCategoryName", width: 120, minWidth: 60, type: "string", align: "left"},
            {
                display: "状态", name: "productStatus", width: 60, minWidth: 60, type: "string", align: "center",
                render: function (item) {
                    return UICtrl.getStatusInfo(item.productStatus);
                }
            },
            {display: "产品数量", name: "productNumber", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "产品计量单位", name: "productUnit", width: 100, minWidth: 60, type: "string", align: "left"},
            {
                display: "BOM有效起始日期",
                name: "productDatuy",
                width: 100,
                minWidth: 60,
                type: "datetime",
                align: "left"
            },
            {display: "ECN号", name: "productAennr", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "样品编号", name: "productSampleCode", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "品牌名称", name: "brandName", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "产品类型", name: "productType", width: 140, minWidth: 60, type: "string", align: "left"}
        ],
        dataType: "server",
        url: web_app.name + '/product/findProduct.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "91.9%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

// parms: {
//     page: 0,
//         size: 30
// },

function updateHandler(data) {
    var id = data.productId;
    if (!id) {
        id = DataUtil.getUpdateRowId(gridManager);
        if (!id) {
            return;
        }
    }
    var url = DataUtil.composeURLByParam('/product/forwardProductDetail2.do', {productId: id});
    UICtrl.addTabItem({tabid: 'viewFlowChart' + id, text: "产品信息", url: url});
}

function addHandler() {
    let data = {};
    var url = DataUtil.composeURLByParam('/product/forwardProductDetail.do', {});
    UICtrl.addTabItem({tabid: 'addProduct' + new Date().getTime(), text: "新增产品", url: url});
}

//启用
function enableHandler() {
    DataUtil.updateById({
        action: 'product/updateAProductStatus.ajax',
        gridManager: gridManager, idFieldName: 'productId', param: {status: 1},
        message: 'common.confirm.enable',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

//禁用
function disableHandler() {
    DataUtil.updateById({
        action: 'product/updateAProductStatus.ajax',
        gridManager: gridManager, idFieldName: 'productId', param: {status: 0},
        message: 'common.confirm.disable',
        onSuccess: function () {
            reloadGrid();
        }
    });
}



