<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="layout,dialog,grid,tree,dateTime,combox,commonTree"/>
    <x:script src='/system/opm/js/OpmUtil.js'/>
    <x:script src='/biz/topsun/common/purchaseCommon.js'/>
    <x:script src='/biz/topsun/customer/customerDetail.js'/>
</head>
<body>
<x:billTitle title="客户信息详情" needStatus="false" needPerson="true"/>
<div class="blank_div clearfix"></div>
<button class="btn btn-default" type="button" id="close" style="left: 200px;float:right;bottom: 10px;">关闭</button>
<button class="btn btn-warning" type="button" id="submit" style="left: 200px;float:right;bottom: 10px;">提交给sap</button>
<button class="btn btn-success" type="button" id="save" style="left: 200px;float:right;bottom: 10px;">保存</button>
<div class="blank_div clearfix"></div>
<form class="hg-form" method="post" action="" id="submitForm">
    <x:hidden name="id"/>
    <x:hidden name="billCode"/>
    <x:hidden name="fillinDate" type="datetime"/>
    <x:hidden name="fullId"/>
    <x:hidden name="organId"/>
    <x:hidden name="organName"/>
    <x:hidden name="deptId"/>
    <x:hidden name="deptName"/>
    <x:hidden name="positionId"/>
    <x:hidden name="positionName"/>
    <x:hidden name="personMemberId"/>
    <x:hidden name="personMemberName"/>

    <div id="customerTab" style="margin: 0px;">
        <div class="ui-tab-links">
            <ul id="customer_ul">
                <li id="customerBaseInfo" divid="customerBaseInfoDiv">客户基本信息</li>
                <li id="customerDebtContact" divid="customerDebtContactDiv">催货款通知邮箱</li>
                <li id="customerOtherInfo" divid="customerOtherInfoDiv">其他信息</li>
                <li id="customerBrand" divid="customerBrandDiv">品牌信息表</li>
                <li id="customerBank" divid="customerBankDiv">银行数据表</li>
                <li id="companyCode" divid="companyCodeDiv">公司代码表</li>
                <li id="salesOrganization" divid="salesOrganizationDiv">销售组织表</li>
            </ul>
        </div>

        <div class="ui-tab-content" style="padding: 2px; padding-right: 0;">
            <div class="layout" id="customerBaseInfoDiv">
                <x:hidden name="customerId"/>
                <x:hidden name="customerBankId"/>
                <x:hidden name="customerOrderId"/>
                <x:hidden name="provinceCode"/>
                <x:hidden name="primaryProvinceCode"/>
                <x:hidden name="secondProvinceCode"/>

                <x:inputC name="customerAccountGroup" label="账户组" labelCol="1" fieldCol="2" required="true"/><%--sap--%>
                <x:inputC name="customerCode" label="客户编号" labelCol="1" fieldCol="2" readonly="true"/><%--sap--%>
                <x:inputC name="customerBusinessPartnerRole" label="业务伙伴角色" labelCol="1" fieldCol="2" required="true"/><%--sap--%>


                <x:inputC name="customerName" label="客户名称" required="true" labelCol="1" fieldCol="2" maxLength="35"/><%--sap、金库查询接口--%>
                <x:inputC name="customerShortName" label="客户简称" required="true" labelCol="1" fieldCol="2" maxLength="20"/><%--sap、金库--%>
                <x:inputC name="customerEnName" label="英文名称" labelCol="1" required="true" fieldCol="2"/><%--金库--%>
                <x:inputC name="customerEnShortName" label="英文名简称" labelCol="1" fieldCol="2" required="true"/><%--金库--%>
                <x:inputC name="customerBillingAddress" label="开票地址" required="true" labelCol="1" fieldCol="2" maxLength="140"/><%--sap--%>
                <x:inputC name="customerDeliveryAddress" label="客户送货地址（固定）" labelCol="1" fieldCol="2" required="true" maxLength="80"/><%--sap--%>




                <x:inputC name="customerCountry" label="国家" labelCol="1" fieldCol="2" required="true"/><%--sap--%>
                <x:inputC name="province" label="省" wrapper="select" id="selectProvince" labelCol="1" fieldCol="2" required="true"/><%--金库--%>
                <x:inputC name="city" label="市" wrapper="select" id="selectCity" labelCol="1" fieldCol="2" required="true"/><%--金库--%>
                <x:inputC name="county" label="区（县）" wrapper="select" id="selectCounty" labelCol="1" fieldCol="2" /><%--金库--%>

                <x:inputC name="customerCity" label="城市" labelCol="1" fieldCol="2" maxLength="40"/><%--sap--%>
                <x:inputC name="customerRegion" label="地区" labelCol="1" fieldCol="2" /><%--sap--%>


                <x:inputC name="customerLanguage" label="语言" labelCol="1" fieldCol="2" required="true"/><%--sap--%>
                <x:inputC name="customerZipCode" label="邮政编码" labelCol="1" fieldCol="2" required="true"/><%--sap、金库--%>
                <x:inputC name="customerTelNumber" label="电话号码" labelCol="1" fieldCol="2" required="true" maxLength="30"/><%--sap--%>
                <x:inputC name="customerMobNumber" label="移动电话" labelCol="1" fieldCol="2" required="true" maxLength="30"/><%--sap--%>
                <x:inputC name="customerSmtpAddr" label="Email" labelCol="1" fieldCol="2" required="true" maxLength="24"/><%--sap--%>

                <x:inputC name="accountDifficultLevel" label="做账难度等级" labelCol="1" fieldCol="2"/><!--sap、金库-->
                <x:selectC name="customerSysOrder" label="要求用客户系统货单" dictionary="customerSysOrder" labelCol="1" fieldCol="2"/><!--sap、金库-->
                <x:selectC name="stampMethod" label="盖章方式" required="true" dictionary="stampMethod" labelCol="1" fieldCol="2"/><!--sap、金库-->
                <x:selectC name="paymentRequestForm" label="请款联" dictionary="paymentRequestFrom" required="true" labelCol="1" fieldCol="2"/><!--sap、金库-->
                <x:selectC name="customerReceipt" label="客户联" required="true" dictionary="customerReceipt" labelCol="1" fieldCol="2"/><!--sap、金库-->
                <x:inputC name="orderRequire" label="订单要求" required="true" labelCol="1" fieldCol="2"/><!--sap、金库-->
                <x:inputC name="acceptanceRequire" label="验收单要求" required="true" labelCol="1" fieldCol="2"/><!--sap、金库-->
                <x:inputC name="customerSysAcceptanceRequire" label="客户系统验收要求" required="true" labelCol="1" fieldCol="2"/><!--sap、金库-->
                <x:selectC name="signedBack" label="是否要求签回货单" dictionary="signedBack" labelCol="1" fieldCol="2"/><!--sap、金库-->
                <x:selectC name="isPrintDeliveryDate" label="货单是否打印送货日期" dictionary="productInspectionReportType" labelCol="1" fieldCol="2"/><!--sap、金库-->
                <x:inputC name="needInvoice" label="不开发票" labelCol="1" fieldCol="2"/><!--sap、金库-->
                <x:inputC name="paymentRequest" label="请款要求" labelCol="1" fieldCol="2" maxLength="200"/><%--sap、金库--%>
                <x:inputC name="customerWorkTime" label="客户工作时间" labelCol="1" fieldCol="2" maxLength="50"/><%--sap、金库--%>
                <x:inputC name="receiverSignatureRequire" label="收货方签字要求" required="true" labelCol="1" fieldCol="2" maxLength="200"/><%--sap、金库--%>
                <x:inputC name="shipPrintRequire" label="货单打印要求" required="true" labelCol="1" fieldCol="2" maxLength="200"/><%--sap、金库--%>
                <x:inputC name="customerGroup" label="所属集团" labelCol="1" fieldCol="2" maxLength="20"/><%--sap、金库--%>
                <x:selectC name="productInspectionReportType" label="产品检验报告类型" dictionary="productInspectionReportType" labelCol="1" fieldCol="2"/><%--sap、金库--%>
                <x:inputC name="signedStyle" label="货单签回方式" required="true" labelCol="1" fieldCol="2"/><%--sap、金库--%>
                <x:selectC name="shipMethod" label="出货方式" required="true" dictionary="shipMethod" labelCol="1" fieldCol="2"/><%--sap、金库--%>
                <x:selectC name="route" label="路线" required="true" dictionary="route" labelCol="1" fieldCol="2"/><%--sap、金库--%>
                <x:inputC name="defaultSettingsOfPrintingDeliveryNotes" label="送货单打印默认设置" required="true" labelCol="1" fieldCol="2"/><%--sap--%>
                <x:inputC name="shipAbnormalDeadline" label="送货单统计异常期限" required="true" labelCol="1" fieldCol="2"/><%--sap、金库--%>
                <x:inputC name="productionDeliveryMethod" label="生产发货方式" labelCol="1" fieldCol="2" required="true"/><%--sap、金库--%>
                <x:inputC name="monthlySettlementMethod" label="月结方式" id="selectedMonthlySettlementMethod" wrapper="select" required="true" labelCol="1" fieldCol="2"/><%--sap、金库查询接口--%>
                <x:inputC name="paymentDeadline" label="请款期限" required="true" labelCol="1" fieldCol="2"/><%--sap、金库--%>
                <x:inputC name="accountDeadline" label="做账截止日" required="true" labelCol="1" fieldCol="2"/><%--sap、金库--%>
                <x:inputC name="customerCollectionDeadline" label="客户收账截止日" required="true" labelCol="1" fieldCol="2"/><%--sap、金库--%>
                <x:inputC name="orderAbnormalDeadline" label="订单统计异常期限" required="true" labelCol="1" fieldCol="2"/><%--sap、金库--%>
                <x:inputC name="customerFactoryCode" label="工厂代号" labelCol="1" fieldCol="2" maxLength="50"/><%--sap品牌、金库--%>
                <x:selectC name="quotationCurrency" label="币别" dictionary="currency" labelCol="1" fieldCol="2"/><%--金库查询接口、sap销售组织字段--%>
                <x:inputC name="deduction" label="扣款百分比" labelCol="1" fieldCol="2"/><%--金库--%>
                <x:inputC name="decimalPlaces" label="金额小数位数" labelCol="1" fieldCol="2"/><%--金库--%>
                <x:inputC name="customerCorporation" label="公司法人" labelCol="1" fieldCol="2"/>
                <x:inputC name="businessRegistrationNumber" label="工商注册号" labelCol="1" fieldCol="2"/>
                <x:inputC name="nationalTaxRegistrationNumber" label="国税注册号" labelCol="1" fieldCol="2"/>
                <x:selectC name="orderKind" label="订单性质" dictionary="orderKind" labelCol="1" fieldCol="2"/>
<%--                <x:inputC name="customerAddress" label="收货地址" labelCol="1" fieldCol="2" required="true"/>--%>
                <x:inputC name="remark" label="备注" labelCol="1" fieldCol="2"/><%--金库查询接口--%>














<%--sap--%>

<%--                <x:inputC name="BUKRS" label="公司代码" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="AKONT" label="统驭科目" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="VKORG" label="销售组织" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="VTWEG" label="分销渠道" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="SPART" label="产品组" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="KDGRP" label="客户组" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="VKBUR" label="销售办公室" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="VKGRP" label="销售小组" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="KLABC" label="客户分类" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="KURST" label="汇率类型" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="PLTYP" label="价格清单" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="INCO1" label="国际贸易条款" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="INCO2" label="国际贸易条款位置" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="ZTERM" label="付款条件" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="KTGRD" label="客户科目分配组" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="TATYP" label="税收类别" labelCol="1" fieldCol="2"/>--%>
<%--                <x:inputC name="TAXKD" label="客户税分类" labelCol="1" fieldCol="2"/>--%>








                <div id="contact" position="center">
                    <x:title title="联系人列表" name="group"/>
                    <div id="contactListGrid" style="margin: 2px;">
                        <hr>
                    </div>
                </div>
            </div>
            <div class="layout" id="customerDebtContactDiv">
                <div id='emailTab' style="margin: 0px;">
                    <div class="ui-tab-links">
                        <ul id="email_ul">
                            <li id="baoshenEmailListForm" divid="baoshenEmailListDiv">宝绅邮箱</li>
                            <li id="customerEmailListForm" divid="customerEmailListDiv">客户邮箱</li>
                        </ul>
                    </div>
                    <div class="ui-tab-content" style="padding: 2px; padding-right: 0;">
                        <div class="layout" id="baoshenEmailListDiv">
                            <div id="baoshenEmailList" position="center">
                                <x:title title="宝绅邮箱列表" name="group"/>
                                <div id="baoshenEmailListGrid" style="margin: 2px;">
                                    <hr>
                                </div>
                            </div>
                        </div>
                        <div class="layout" id="customerEmailListDiv">
                            <div id="customerEmailList" position="center">
                                <x:title title="客户邮箱列表" name="group"/>
                                <div id="customerEmailListGrid" style="margin: 2px;">
                                    <hr>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
            <div class="layout" id="customerOtherInfoDiv">
                <div id="customerRelated" position="center">
                    <x:title title="客户关联关系信息" name="group"/>
                    <div id="customerRelatedListGrid" style="margin: 2px;">
                        <hr>
                    </div>
                </div>
                <div id="customerPayInfo" position="center">
                    <x:title title="客户付款信息" name="group"/>
                    <div id="customerPayInfoListGrid" style="margin: 2px;">
                        <hr/>
                    </div>
                </div>
            </div>

            <div class="layout" id="customerBrandDiv">
                <div id="customerBrandGrid">
                    <x:title title="客户品牌信息表" name="group"/>
                    <div id="customerBrandListGrid" style="margin: 2px;">
                        <hr/>
                    </div>

                </div>
            </div>
            <div class="layout" id="customerBankDiv">
                <div id="customerBankGrid">
                    <x:title title="客户银行数据表" name="group"/>
                    <div id="customerBankListGrid" style="margin: 2px;">
                        <hr/>
                    </div>

                </div>
            </div>
            <div class="layout" id="companyCodeDiv">
                <div id="companyCodeGrid">
                    <x:title title="公司代码表" name="group"/>
                    <div id="companyCodeListGrid" style="margin: 2px;">
                        <hr/>
                    </div>

                </div>
            </div><div class="layout" id="salesOrganizationDiv">
            <div id="salesOrganizationGrid">
                <x:title title="销售组织表" name="group"/>
                <div id="salesOrganizationListGrid" style="margin: 2px;">
                    <hr/>
                </div>

            </div>
        </div>

        </div>
    </div>


</form>
</body>
</html>