var contactGridManager = null;
var baoshenEmailGridManager = null;
var customerEmailGridManager = null;
var customerRelatedGridManager = null;
var customerPayInfoGridManager = null;
var customerBrandGridManager = null;
var customerBankGridManager = null;
var companyCodeGridManager = null;
var salesOrganizationGridManager = null;
var provinceCode = null;
var cityCode = null;
var countyCode = null;
var currentTabId = UICtrl.getCurrentTabId();
$(document).ready(function () {
    provinceCode = getPrimaryProvinceCode();
    cityCode = getSecondProvinceCode();
    initializeTab();
    initializeUI();
    initializeSelectMethod();
    loadContactListGrid();
    bindEvent();
    loadBaoshenEmailListGrid();
    loadCustomerEmailListGrid();
    loadCustomerRelatedListGrid();
    loadCustomerPayInfoListGrid();
    loadCustomerBrandListGrid();
    loadCustomerBankListGrid();
    loadCompanyCodeListGrid(currentTabId);
    loadSalesOrganizationGrid(currentTabId);

    // //添加客户操作
    // if (currentTabId="addCustomerDetail"){
    //
    // }

});


function initializeUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function initializeTab() {
    $('#customerTab').tab();
    $('#emailTab').tab()
}

function initializeSelectMethod() {


    $('#selectedMonthlySettlementMethod').searchbox({
        type: "monthlySettlementMethod",
        name: "monthlySettlementMethodApplyCode",
        onChange: function (value, data) {
            $('#selectedMonthlySettlementMethod').val(data.method)
        }
    })


    $('#selectProvince').searchbox({
        type: "province",
        name: "provinceCode",
        onChange: function (value, data) {
            $('#selectProvince').val(data.provinceName)
            provinceCode = data.provinceCode;
            $('#primaryProvinceCode').val(data.provinceCode);
            $('#selectCity').val(null);
            $('#selectCounty').val(null);

        }
    })


    $('#selectCity').searchbox({
        type: "province",
        name: "cityCode",
        getParam: function () {
            /*var provinceCode=$('#provinceCode').val();
            if(provinceCode==''){
                Public.tip('请先选择省份!');
                return false;
            }*/
            if (provinceCode == null || provinceCode == ""
                || getPrimaryProvinceCode() == null || getPrimaryProvinceCode() == ""
                || $('#selectProvince').val() == null || $('#selectProvince').val() == "") {
                Public.tip('请先选择省份!');
                return false;
            }
            return {provinceCode: provinceCode};
        },
        onChange: function (value, data) {
            $('#selectCity').val(data.provinceName)
            cityCode = data.provinceCode
            $('#secondProvinceCode').val(data.provinceCode);
            $('#selectCounty').val(null);
            $('#provinceCode').val(data.provinceCode);
        }

    })

    $('#selectCounty').searchbox({
        type: "province",
        name: "cityCode",
        getParam: function () {
            // var provinceCode=$('#provinceCode').val();
            // if(provinceCode==''){
            //     Public.tip('请先选择地级市!');
            //     return false;
            // }
            if (cityCode == null || cityCode == ''
                || getSecondProvinceCode() == null || getSecondProvinceCode() == ""
                || $('#selectCity').val() == null || $('#selectCity').val() == "") {
                Public.tip('请先选择地级市!');
                return false;
            }
            debugger;
            return {provinceCode: cityCode};
        },
        onChange: function (value, data) {
            $('#selectCounty').val(data.provinceName);
            countyCode = data.provinceCode;
            $('#provinceCode').val(data.provinceCode);
        }
    })
}


function loadContactListGrid() {
    //增删改控件
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addContactHandler();
        },
        deleteHandler: function () {
            deleteContactHandler();
        }
    });
    contactGridManager = UICtrl.grid("#contactListGrid", {
        columns: [
            {
                display: "联系人名称", name: "contactName", width: 150, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "职位", name: "contactPosition", width: 150, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "联系人电话", name: "contactPhone", width: 260, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "传真", name: "contactFax", width: 260, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false, type: "text"
                }
            },
            {
                display: "邮箱", name: "contactEmail", width: 260, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                }
            }
        ],
        dataAction: "server",
        url: web_app.name + '/customer/slicedContactList.ajax',
        parms: {customerId: $("#customerId").val()},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "40%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,

    });
    UICtrl.setSearchAreaToggle(contactGridManager);
}


//添加联系人
function addContactHandler() {
    UICtrl.addGridRow(contactGridManager);
}

//删除联系人
function deleteContactHandler() {
    var _grid = UICtrl.getGridManager('#contactListGrid');
    DataUtil.delSelectedRows(
        {
            action: 'customer/deleteContact.ajax',
            param: {},
            gridManager: _grid,
            idFieldName: 'customerContactId',
            onSuccess: function (data) {
                if (data == "1") {
                    Public.successTip("删除成功！");
                }
                contactGridManager.loadData();
            }
        }
    )
}


function loadBaoshenEmailListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(baoshenEmailGridManager);
            },
            deleteHandler: function () {
                deleteBaoshenEmailHandler();

            }
        }
    );
    baoshenEmailGridManager = UICtrl.grid("#baoshenEmailListGrid", {
        columns: [
            {
                display: "邮箱地址", name: "customerEmail", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                },

            },
            {
                display: "联系人", name: "customerContact", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                },
            },
            {
                display: "是否开启邮件发送",
                name: "sendEmailTextView",
                width: 300,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {

                    type: 'dictionary',
                    data: {
                        name: 'yesorno'
                    },
                    textField: 'sendEmailTextView',
                    valueField: 'sendEmail',
                    required: true

                },
            },
            {
                display: "创建人", name: "createdByName", width: 300, minWidth: 60, type: "string", align: "left",

            }
        ],
        dataAction: "server",
        url: web_app.name + '/customerDebtContact/slicedCustomerDebtContactList.ajax',
        parms: {customerId: $("#customerId").val(), customerEmailType: 0},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "60%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}

function deleteBaoshenEmailHandler() {
    var _grid = UICtrl.getGridManager('#baoshenEmailListGrid');
    DataUtil.delSelectedRows(
        {
            action: 'customerDebtContact/deleteCustomerDebtContact.ajax',
            param: {},
            gridManager: _grid,
            idFieldName: 'customerDebtContactId',
            onSuccess: function (data) {
                if (data == "1") {
                    Public.successTip("删除成功！");
                }
                baoshenEmailGridManager.loadData();
            }
        }
    )
}

function loadCustomerEmailListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(customerEmailGridManager);
            },
            deleteHandler: function () {
                deleteCustomerEmailHandler();

            }
        }
    );
    customerEmailGridManager = UICtrl.grid("#customerEmailListGrid", {
        columns: [
            {
                display: "邮箱地址", name: "customerEmail", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "联系人", name: "customerContact", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "是否开启邮件发送",
                name: "sendEmailTextView",
                width: 300,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {

                    type: 'dictionary',
                    data: {
                        name: 'yesorno'
                    },
                    textField: 'sendEmailTextView',
                    valueField: 'sendEmail',
                    required: true

                },
            },
            {
                display: "创建人", name: "createdByName", width: 300, minWidth: 60, type: "string", align: "left",

            }
        ],
        dataAction: "server",
        url: web_app.name + '/customerDebtContact/slicedCustomerDebtContactList.ajax',
        parms: {customerId: $("#customerId").val(), customerEmailType: 1},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "60%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}

function deleteCustomerEmailHandler() {
    var _grid = UICtrl.getGridManager('#customerEmailListGrid');
    DataUtil.delSelectedRows(
        {
            action: 'customerDebtContact/deleteCustomerDebtContact.ajax',
            param: {},
            gridManager: _grid,
            idFieldName: 'customerDebtContactId',
            onSuccess: function (data) {
                if (data == "1") {
                    Public.successTip("删除成功！");
                }
                customerEmailGridManager.loadData();
            }
        }
    )
}

function loadCustomerRelatedListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(customerRelatedGridManager);
            },
            deleteHandler: function () {
                deleteCustomerRelatedHandler();

            }
        }
    );
    customerRelatedGridManager = UICtrl.grid("#customerRelatedListGrid", {
        columns: [
            {
                display: "关联客户编码",
                name: "customerCodeRelated",
                width: 200,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "关联客户简称",
                name: "customerShortNameRelated",
                width: 200,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "关联客户全称",
                name: "customerNameRelated",
                width: 200,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "录入人", name: "createdByName", width: 200, minWidth: 60, type: "string", align: "left",

            },
            {
                display: "录入时间", name: "createdDate", width: 200, minWidth: 60, type: "string", align: "left",

            },

        ],
        dataAction: "server",
        url: web_app.name + '/customerRelated/slicedCustomerRelatedList.ajax',
        parms: {customerId: $("#customerId").val()},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "40%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}

function deleteCustomerRelatedHandler() {
    var _grid = UICtrl.getGridManager('#customerRelatedListGrid');
    DataUtil.delSelectedRows(
        {
            action: 'customerRelated/deleteCustomerRelated.ajax',
            param: {},
            gridManager: _grid,
            idFieldName: 'customerRelatedId',
            onSuccess: function (data) {
                if (data == "1") {
                    Public.successTip("删除成功！");
                }
                customerRelatedGridManager.loadData();
                // loadCustomerRelatedListGrid();
            }
        }
    )
}

function loadCustomerPayInfoListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(customerPayInfoGridManager);
            },

            deleteHandler: function () {
                deleteCustomerPayInfoHandler();

            }
        }
    );
    customerPayInfoGridManager = UICtrl.grid("#customerPayInfoListGrid", {
        columns: [
            {
                display: "支付方户名",
                name: "customerPayAccountName",
                width: 200,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "录入人", name: "createdByName", width: 200, minWidth: 60, type: "string", align: "left",

            },
            {
                display: "录入时间", name: "createdDate", width: 200, minWidth: 60, type: "date", align: "left",

            },
            {
                display: "修改人", name: "lastModifiedByName", width: 200, minWidth: 60, type: "string", align: "left",
            },
            {
                display: "修改时间", name: "lastModifiedDate", width: 200, minWidth: 60, type: "date", align: "left",

            }
        ],
        dataAction: "server",
        url: web_app.name + '/customerPayInfo/slicedCustomerPayInfoList.ajax',
        parms: {customerId: $("#customerId").val()},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "40%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}

function loadCustomerBrandListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(customerBrandGridManager);
            },

            deleteHandler: function () {
                deleteCustomerBrandHandler();

            }
        }
    );
    customerBrandGridManager = UICtrl.grid("#customerBrandListGrid", {
        columns: [
            {
                display: "品牌",
                name: "brand",
                width: 100,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: false,
                    type: "text"
                }
            },
            {
                display: "职位", name: "position", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: "text"
                }

            },
            {
                display: "录入时间", name: "createdDate", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: "text"
                }
            },
            {
                display: "联系人", name: "contact", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: "text"
                }
            },
            {
                display: "电话号码", name: "tel", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: "text"
                }
            },
            {
                display: "e-Mail", name: "eMail", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: "text"
                }
            },
            {
                display: "经营类型", name: "operateType", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: "text"
                }
            },
            {
                display: "工厂代码", name: "factoryCode", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: "text"
                }
            },
            {
                display: "跟单员", name: "merchandiser", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: "text"
                }
            }
        ],
        dataAction: "server",
        url: web_app.name + '/customerBrand/slicedCustomerBrandList.ajax',
        parms: {customerId: $("#customerId").val()},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}
function deleteCustomerBrandHandler() {
    var _grid = UICtrl.getGridManager('#customerBrandListGrid');
    DataUtil.delSelectedRows(
        {
            action: 'customerBrand/deleteCustomerBrand.ajax',
            param: {},
            gridManager: _grid,
            idFieldName: 'customerBrandId',
            onSuccess: function (data) {
                if (data == "1") {
                    Public.successTip("删除成功！");
                }
                customerBrandGridManager.loadData();
            }
        }
    )

}

function loadCustomerBankListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(customerBankGridManager);
            },

            deleteHandler: function () {
                // deleteCustomerBankHandler();

            }
        }
    );
    customerBankGridManager = UICtrl.grid("#customerBankListGrid", {
        columns: [
            {
                display: "开户银行代码",
                name: "depositBankCode",
                width: 200,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "银行账号", name: "bankAccount", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }

            },
            {
                display: "账户持有人姓名", name: "accountHolderName", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }

            }
        ],
        dataAction: "server",
        url: web_app.name + '/customerBankList/slicedCustomerBankList.ajax',
        parms: {customerId: $("#customerId").val()},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}

function loadCompanyCodeListGrid(currentTabId) {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(companyCodeGridManager);
            },

            deleteHandler: function () {
                // deleteCompanyCodeHandler();

            }
        }
    );
    companyCodeGridManager = UICtrl.grid("#companyCodeListGrid", {
        columns: [
            {
                display: "公司代码",
                name: "companyCode",
                width: 200,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "统驭科目", name: "reconciliationAccount", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }

            },
            {
                display: "付款条件", name: "companyPaymentTerms", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }

            },
            {
                display: "催款过程", name: "collectionProcess", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }

            }
        ],
        dataAction: "server",
        url: web_app.name + '/customerCompanyCode/slicedCustomerCompanyCodeList.ajax',
        parms: {customerId: $("#customerId").val()},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });

}

function loadSalesOrganizationGrid(currentTabId) {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(salesOrganizationGridManager);
            },

            deleteHandler: function () {
                // deleteCompanyCodeHandler();

            }
        }
    );
    salesOrganizationGridManager = UICtrl.grid("#salesOrganizationListGrid", {
        columns: [
            {
                display: "销售组织",
                name: "organization",
                width: 10,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "分销渠道", name: "distributionChannel", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }

            },
            {
                display: "产品组", name: "productGroup", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }

            },
            {
                display: "销售办公室", name: "salesOffice", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: "text"
                }
            },
            {
                display: "销售小组", name: "salesGroup", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: "text"
                }
            },
            {
                display: "客户等级（客户分类）", name: "customerGrade", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: "text"
                }
            },
            {
                display: "币别", name: "currency", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true,
                    type: "text",
                }
            },
            {
                display: "汇率类型", name: "exchangeRate", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true,
                    type: "text",
                }
            },
            {
                display: "国际贸易条款", name: "incoterm", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: "text"
                }
            },
            {
                display: "国际贸易条款位置", name: "incotermPosition", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: "text"
                }
            },
            {
                display: "付款条件", name: "salesPaymentTerms", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true,
                    type: "text",
                }
            },
            {
                display: "客户科目分配组", name: "customerAccountAllocationGroup", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true,
                    type: "text",
                }
            },
            {
                display: "税收类别", name: "taxCategory", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true,
                    type: "text",
                }
            },
            {
                display: "客户税分类", name: "customerTaxClassification", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true,
                    type: "text",
                }
            },
            {
                display: "装运条件", name: "shippingConditions", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false,
                    type: "text"
                }
            }
        ],
        dataAction: "server",
        url: web_app.name + '/customerSalesOrganization/slicedCustomerSalesOrganizationList.ajax',
        parms: {customerId: $("#customerId").val()},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}


function deleteCustomerPayInfoHandler() {
    var _grid = UICtrl.getGridManager('#customerPayInfoListGrid');
    DataUtil.delSelectedRows(
        {
            action: 'customerPayInfo/deleteCustomerPayInfo.ajax',
            param: {},
            gridManager: _grid,
            idFieldName: 'customerPayInfoId',
            onSuccess: function (data) {
                if (data == "1") {
                    Public.successTip("删除成功！");
                }
                customerPayInfoGridManager.loadData();
            }
        }
    )
}


function bindEvent() {
    $("#save").click(function () {//保存整体保存
        saveData();
    })

    $("#submit").click(function () {//提交给sap
        submitToSap();
    })

    $("#close").click(function () {//关闭
        closeDispatchTabItem();
    })
}

function getCustomerDetail() {
    var contactList = [];
    var baoshenEmailList = [];
    var customerEmailList = [];
    var customerRelatedList = [];
    var customerPayInfoList = [];
    var customerVo = $('#submitForm').formToJSON(true);
    if (!customerVo) {
        return false;
    }
    contactList = DataUtil.getGridData({gridManager: contactGridManager, isAllData: true})
    baoshenEmailList = DataUtil.getGridData({gridManager: baoshenEmailGridManager, isAllData: true})
    customerEmailList = DataUtil.getGridData({gridManager: customerEmailGridManager, isAllData: true})
    customerRelatedList = DataUtil.getGridData({gridManager: customerRelatedGridManager, isAllData: true})
    customerPayInfoList = DataUtil.getGridData({gridManager: customerPayInfoGridManager, isAllData: true})
    customerVo.contactList = $.toJSON(contactList);
    customerVo.baoshenEmailList = $.toJSON(baoshenEmailList);
    customerVo.customerEmailList = $.toJSON(customerEmailList);
    customerVo.customerRelatedList = $.toJSON(customerRelatedList);
    customerVo.customerPayInfoList = $.toJSON(customerPayInfoList);
    return customerVo;

}

//右上角的保存控件
function saveData() {
    var customerDetail = getCustomerDetail();
    if (!customerDetail) {
        return;
    }
    Public.ajax(web_app.name + '/customer/saveCustomer.ajax', customerDetail,
        function (data) {
            Public.successTip("common.tip.success");
            contactGridManager.setParm('customerId', data.customerId);
            contactGridManager.loadData();
            baoshenEmailGridManager.setParm('customerId', data.customerId);
            baoshenEmailGridManager.loadData();
            customerEmailGridManager.setParm('customerId', data.customerId);
            customerEmailGridManager.loadData();
            customerRelatedGridManager.setParm('customerId', data.customerId);
            customerRelatedGridManager.loadData();
            customerPayInfoGridManager.setParm('customerId', data.customerId);
            customerPayInfoGridManager.loadData();
        }
    );
}

function submitToSap() {
    var customerDetail = getCustomerDetail();
    if (!customerDetail) {
        return;
    }
    Public.ajax(web_app.name + '/customer/submitCustomerToSAP.ajax', customerDetail,
        function () {
            Public.successTip("common.tip.success");
        }
    )
}

function closeDispatchTabItem() {
    UICtrl.closeCurrentTab();
}

function getPrimaryProvinceCode() {
    var provinceCode = $('#primaryProvinceCode').val();
    return provinceCode;
}

function getSecondProvinceCode() {
    var cityCode = $('#secondProvinceCode').val();
    return cityCode;
}
