package com.huigou.topsun.technology.domain.query;

import com.alibaba.fastjson.JSON;
import com.huigou.data.domain.query.QueryAbstractRequest;
import lombok.Data;

import java.io.Serializable;

/**
 * 工序
 * @TableName process
 */
@Data
public class TechnologyProcessQueryRequest extends QueryAbstractRequest {
    /**
     * 工艺节点条目ID
     */
    private String technologyProcessId;

    /**
     * 工艺ID
     */
    private String technologyId;

    /**
     * 工序ID
     */
    private String processId;

    /**
     * 条目序号
     */
    private Integer sortNum;


    /**
     * 工序名称
     */
    private String processName;

    /**
     * 工序说明
     */
    private String processRemark;

    /**
     * 工时
     */
    private Double workHours;

    /**
     * 工序类别(process_type)
     */
    private String processType;

    /**
     * 工序内容
     */
    private String processContent;
}