package com.huigou.topsun.technology.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.technology.application.ProcessApplication;
import com.huigou.topsun.technology.application.ProcessMaterialItemApplication;
import com.huigou.topsun.technology.application.ProcessResourceApplication;
import com.huigou.topsun.technology.domain.model.Process;
import com.huigou.topsun.technology.domain.model.ProcessMaterialItem;
import com.huigou.topsun.technology.domain.model.ProcessResource;
import com.huigou.topsun.technology.domain.query.ProcessQueryRequest;
import com.huigou.topsun.technology.repository.ProcessRepository;
import com.huigou.topsun.technology.vo.ProcessVo;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
* @author 16508
* @description 针对表【process(工序)】的数据库操作Service实现
* @createDate 2023-11-22 11:04:03
*/
@Service
public class ProcessApplicationImpl extends BaseApplication implements ProcessApplication {
    @Resource
    private ProcessRepository processRepository;
    @Resource
    private ProcessResourceApplication processResourceApplication;
    @Resource
    private ProcessMaterialItemApplication processMaterialItemApplication;

    @Override
    public ProcessVo saveProcess(ProcessVo processVo) {
        Process process = ProcessVo.getProcess(processVo);
        process = processRepository.saveAndFlush(process);
        processVo.setProcessId(process.getProcessId());
        return processVo;
    }

    @Override
    public void deleteProcessByProcessId(String processId) {
        processRepository.delete(processId);
    }

    @Override
    public Map<String, Object> slicedProcessList(ProcessQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "processList");
        QueryModel model = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
        model.putDictionary("processType", DictUtil.getDictionary("processType"));
        return this.sqlExecutorDao.executeSlicedQuery(model);
    }

    @Override
    public ProcessVo findProcessByProcessId(String processId) {
        Process process = processRepository.findOne(processId);
        return ProcessVo.getProcessVo(process);
    }

    @Override
    public void deleteProcessByProcessIds(List<String> ids) {
        ids.forEach(this::deleteProcessByProcessId);
    }

    @Override
    public ProcessVo saveProcessAndResourceAndMaterial(ProcessVo processVo, List<ProcessResource> resourceList, List<ProcessMaterialItem> processMaterialList) {
        processVo = this.saveProcess(processVo);
        processResourceApplication.saveProcessResource(processVo.getProcessId(),resourceList);
        processMaterialItemApplication.saveProcessMaterialItem(processVo.getProcessId(),processMaterialList);
        return processVo;
    }

}




