package com.huigou.topsun.sap.fixedAssets.application.impl;

import com.huigou.context.Operator;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.demo.domain.model.Leave;
import com.huigou.topsun.sap.fixedAssets.application.SapFixedAssetsApplication;
import com.huigou.topsun.sap.fixedAssets.domain.SapFixedAssets;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedAssetsQueryRequest;
import com.huigou.topsun.sap.fixedAssets.domain.vo.SapFixedAssetsVo;
import com.huigou.topsun.sap.fixedAssets.repository.SapFixedAssetsRepository;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bpm.FlowBroker;
import com.huigou.util.ClassHelper;
import com.huigou.util.StringUtil;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/21/9:37
 * @Description:
 */
@Service("sapFixedAssetsApplication")
public class SapFixedAssetsApplicationImpl extends FlowBroker implements SapFixedAssetsApplication {

    @Autowired
    private SapFixedAssetsRepository sapFixedAssetsRepository;

    @Override
    public Map<String, Object> getFixedAssetsList(SapFixedAssetsQueryRequest sapFixedAssetsQueryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sapFixedAssets");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, sapFixedAssetsQueryRequest);
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        return map;

    }

    @Override
    public SapFixedAssetsVo getFixedAssetsById(String id) {
        return SapFixedAssetsVo.getSapFixedAssetsVo(sapFixedAssetsRepository.getOne(id));
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id -> sapFixedAssetsRepository.delete(id));
    }

    @Override
    public SapFixedAssetsVo saveAndUpdate(SapFixedAssets sapFixedAssets, Operator operator) {
        // 判断修改还是新增
        if (StringUtil.isNotBlank(sapFixedAssets.getId())) {
            // 修改
            // 将标识修改为2
            sapFixedAssets.setZflg(2);
            sapFixedAssets = sapFixedAssetsRepository.saveAndFlush(sapFixedAssets);
        } else {
            // 新增
            // 封装填报时间
            long timestamp = System.currentTimeMillis();
            sapFixedAssets.setFillinDate(new Date(timestamp));
            // 封装人员信息
            sapFixedAssets.setFullId(operator.getFullId());
            sapFixedAssets.setOrganId(operator.getOrgId());
            sapFixedAssets.setOrganName(operator.getOrgName());
            sapFixedAssets.setDeptId(operator.getDeptId());
            sapFixedAssets.setDeptName(operator.getDeptName());
            sapFixedAssets.setPositionId(operator.getPositionId());
            sapFixedAssets.setPositionName(operator.getPositionName());
            sapFixedAssets.setPersonMemberId(operator.getPersonMemberId());
            sapFixedAssets.setPersonMemberName(operator.getPersonMemberName());
            sapFixedAssets.setStatusId(BizBillStatus.APPLYING.getId());
            sapFixedAssets.setZflg(1);
            sapFixedAssets = sapFixedAssetsRepository.saveAndFlush(sapFixedAssets);
        }
        return SapFixedAssetsVo.getSapFixedAssetsVo(sapFixedAssets);
    }

    @Override
    protected void onEnd(DelegateExecution delegateExecution) {
        super.onEnd(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        BizBillStatus status = approvePassed() ? BizBillStatus.COMPLETED : BizBillStatus.ABORTED;
        SapFixedAssets fixedAssets = sapFixedAssetsRepository.findOne(bizId);
        fixedAssets.setStatusId(status.getId());
        sapFixedAssetsRepository.save(fixedAssets);
    }

    @Override
    protected void onAbortProcessInstance(DelegateExecution delegateExecution) {
        super.onAbortProcessInstance(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        SapFixedAssets fixedAssets = sapFixedAssetsRepository.findOne(bizId);
        fixedAssets.setStatusId(BizBillStatus.ABORTED.getId());
        sapFixedAssetsRepository.save(fixedAssets);
    }

    @Override
    protected void onBack(DelegateTask delegateTask, String destActivityId) {
        super.onBack(delegateTask, destActivityId);
        if ("Apply".equalsIgnoreCase(destActivityId)) {
            String bizId = delegateTask.getExecution().getProcessBusinessKey();
            SapFixedAssets fixedAssets = sapFixedAssetsRepository.findOne(bizId);
            fixedAssets.setStatusId(BizBillStatus.APPLYING.getId());
            sapFixedAssetsRepository.save(fixedAssets);
        }
    }

    @Override
    protected Map<String, Object> getProcessBizParams(String bizId) {
        return ClassHelper.toMap(sapFixedAssetsRepository.getOne(bizId));
    }

    @Override
    protected String saveBizAndApprovalData() {
        super.saveBizAndApprovalData();
        SapFixedAssets sapFixedAssets = getBizEntity(SapFixedAssets.class);

        if (sapFixedAssets.isNew()) {
            sapFixedAssets.setStatusId(BizBillStatus.APPLYING.getId());
        } else {
            sapFixedAssets = (SapFixedAssets)  commonDomainService.loadAndFillinProperties(sapFixedAssets);
        }
        sapFixedAssets = sapFixedAssetsRepository.save(sapFixedAssets);
        return sapFixedAssets.getId();
    }
}
