package com.huigou.topsun.resource.vo;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.huigou.topsun.resource.domain.ResourceFiled;
import com.topsunit.query.annotations.Dictionary;
import lombok.Data;

import java.io.Serializable;

/**
 * 资源字段设置
 * @TableName resource_filed
 */
//@Schema(description = "资源字段设置")
@Data
public class ResourceFiledVo implements Serializable {
    /**
     * 资源字段ID
     */
    //@Schema(description = "资源字段ID")
    private String resourceFieldId;

    /**
     * 所属资源类型
     */
    //@Schema(description = "所属资源类型ID")
    private String resourceTypeId;

    /**
     * 字段名
     */
    //@Schema(description = "字段名")
    private String resourceFieldName;

    /**
     * 字段值
     */
    private Object resourceFieldValue = "";

    /**
     * 字段显示名
     */
    //@Schema(description = "字段显示名")
    private String resourceFiledTitle;

    /**
     * 字段类型
     */
    //@Schema(description = "字段类型，码表（resourceFieldType)）
    @Dictionary("resourceFieldType")
    private String resourceFieldType;

    private String resourceFieldTypeTextView;

    /**
     * 是否可见
     */
    //@Schema(description = "是否可见，码表（resourceFieldShow））")
    private String resourceFieldShow;

    private String resourceFieldShowTextView;

    /**
     * 字段大小
     */
    //@Schema(description = "字段大小")
    private Integer resourceFieldSize;

    /**
     * 整型长度
     */
    //@Schema(description = "整型长度")
    private Integer integerLength;

    /**
     * 小数点位数
     */
    //@Schema(description = "小数点位数")
    private Integer decimalPrecision;

    /**
     * 序号
     */
    //@Schema(description = "序号")
    private Integer sortNum;

    /**
     * 对应码表的编码/选择的表的关联字段
     */
    //@Schema(description = "对应码表的编码")
    private String dictCode;

    private String dbResourceFieldName;

    public static ResourceFiledVo getResourceFiledVo(ResourceFiled resourceFiled){
        return JSON.parseObject(JSON.toJSONString(resourceFiled),ResourceFiledVo.class);
    }

    public static ResourceFiled getResourceFiled(ResourceFiledVo resourceFiledVo){
        return JSON.parseObject(JSON.toJSONString(resourceFiledVo),ResourceFiled.class);
    }

}