package com.huigou.topsun.quotation.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.quotation.application.QuotationItemApplication;
import com.huigou.topsun.quotation.domain.model.QuotationItem;
import com.huigou.topsun.quotation.repository.QuotationItemRepository;
import com.huigou.topsun.quotation.vo.QuotationItemVo;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
* @author 16508
* @description 针对表【quotation_item(报价单明细)】的数据库操作Service实现
* @createDate 2023-11-28 13:59:10
*/
@Service
public class QuotationItemApplicationImpl extends BaseApplication implements QuotationItemApplication {

    @Resource
    private QuotationItemRepository quotationItemRepository;
    @Override
    public void saveQuotationItems(String quotationId,List<QuotationItem> quotationItems) {
        quotationItems.forEach(quotationItem -> {
            quotationItem.setQuotationId(quotationId);
        });
         quotationItemRepository.save(quotationItems);
    }

    @Override
    public void deleteQuotationItem(List<String> ids) {
        ids.forEach(id->{
            quotationItemRepository.delete(id);
        });
    }

    @Override
    public void deleteQuotationItemByQuotationId(String quotationId) {
        List<QuotationItem> itemList = this.findQuotationItemByQuotationId(quotationId);
        quotationItemRepository.delete(itemList);
    }

    @Override
    public List<QuotationItem> findQuotationItemByQuotationId(String quotationId) {
        return quotationItemRepository.findByQuotationId(quotationId);
    }

    @Override
    public QuotationItem findById(String id) {
        return quotationItemRepository.findOne(id);
    }

    @Override
    public List<QuotationItemVo> queryQuotationItemList(String quotationId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "queryQuotationItemList");
        return this.sqlExecutorDao.queryToList(queryDescriptor.getSql(), QuotationItemVo.class,quotationId);
    }
}




